/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.servlet.GeneratedJavaScriptHandler;
import org.directwebremoting.util.LocalUtil;

public abstract class BaseDtoHandler
extends GeneratedJavaScriptHandler {
    protected ConverterManager converterManager;
    protected String generateDtoClasses;
    private static final Log log = LogFactory.getLog(BaseDtoHandler.class);

    protected String generateTemplate(String contextPath, String servletPath, String pathInfo) throws IOException {
        if (!this.generateDtoClasses.matches(".*\\bdto\\b.*")) {
            return null;
        }
        String jsClassName = pathInfo;
        if (!jsClassName.startsWith(this.getBaseDtoPath()) || !jsClassName.endsWith(".js")) {
            return null;
        }
        jsClassName = jsClassName.substring(this.getBaseDtoPath().length());
        if (!LocalUtil.isValidMappedClassName(jsClassName = jsClassName.substring(0, jsClassName.length() - ".js".length()))) {
            log.debug((Object)("Throwing at request for class with name: '" + jsClassName + "'"));
            throw new SecurityException("Illegal mapped class name.");
        }
        if (jsClassName.contains("/")) {
            Pattern p = Pattern.compile(jsClassName.replaceAll("/", "[/\\.]"));
            String match = null;
            for (String convJsClassName : this.converterManager.getNamedConverterJavaScriptNames()) {
                if (!p.matcher(convJsClassName).matches()) continue;
                if (match == null) {
                    match = convJsClassName;
                    continue;
                }
                throw new IllegalArgumentException("DTO script name '" + jsClassName + "' matches several converters.");
            }
            if (match != null) {
                jsClassName = match;
            }
        }
        return this.generateDtoScript(contextPath, servletPath, jsClassName);
    }

    protected abstract String getBaseDtoPath();

    public abstract String generateDtoScript(String var1, String var2, String var3);

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setGenerateDtoClasses(String generateDtoClasses) {
        this.generateDtoClasses = generateDtoClasses;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getBaseDtoPath() + ")";
    }
}

