/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.servlet.BaseDtoHandler;
import org.directwebremoting.servlet.CommonJsAmdModule;
import org.directwebremoting.util.LocalUtil;

public class CommonJsAmdDtoHandler
extends BaseDtoHandler {
    protected String commonJsAmdDtoHandlerUrl;
    protected String commonJsAmdDwrBaseModulePath;
    protected String commonJsAmdDtoBaseModulePath;

    protected String getBaseDtoPath() {
        return this.commonJsAmdDtoHandlerUrl;
    }

    public String generateDtoScript(String contextPath, String servletPath, String jsClassName) {
        String script = null;
        String dtojs = this.remoter.generateDtoJavaScript(jsClassName, "  ", "c");
        if (dtojs != null) {
            NamedConverter namedConv = this.converterManager.getNamedConverter(jsClassName);
            String jsSuperClassName = namedConv.getJavascriptSuperClass();
            CommonJsAmdModule mod = new CommonJsAmdModule(contextPath, servletPath);
            mod.addDependency(this.commonJsAmdDwrBaseModulePath, "engine", "dwr");
            if (LocalUtil.hasLength(jsSuperClassName)) {
                mod.addDependency(this.commonJsAmdDtoBaseModulePath, jsSuperClassName, "parent");
            }
            mod.addContent("  var c;\n");
            mod.addContent("\n");
            mod.addContent(dtojs);
            mod.addContent("    dwr.engine._mappedClasses[\"" + jsClassName + "\"] = c;\n");
            if (LocalUtil.hasLength(jsSuperClassName)) {
                String classExpression = "dwr.engine._mappedClasses[\"" + jsClassName + "\"]";
                mod.addContent(this.remoter.generateDtoInheritanceJavaScript("    ", classExpression, "parent", "dwr.engine._delegate"));
            }
            mod.addContent("\n");
            mod.addContent("  return c;\n");
            script = mod.toString();
        }
        return script;
    }

    public void setCommonJsAmdDtoHandlerUrl(String commonJsAmdDtoHandlerUrl) {
        this.commonJsAmdDtoHandlerUrl = commonJsAmdDtoHandlerUrl;
    }

    public void setCommonJsAmdDwrBaseModulePath(String modulePath) {
        this.commonJsAmdDwrBaseModulePath = modulePath;
    }

    public void setCommonJsAmdDtoBaseModulePath(String modulePath) {
        this.commonJsAmdDtoBaseModulePath = modulePath;
    }
}

