/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.support.RequestContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCreator
extends AbstractCreator
implements Creator {
    private String beanName = null;
    private static final Log log = LogFactory.getLog(SpringCreator.class);
    private BeanFactory factory = null;
    private static BeanFactory overrideFactory = null;
    private Class<?> clazz = null;
    private String[] configLocation = null;

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class not found: " + classname, ex);
        }
    }

    @Override
    public void setProperties(Map<String, String> params) throws IllegalArgumentException {
        ArrayList<String> locValues = new ArrayList<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith("location")) continue;
            log.debug((Object)("Adding configLocation: " + value + " from parameter: " + key));
            locValues.add(value);
        }
        this.configLocation = locValues.toArray(new String[locValues.size()]);
    }

    @Override
    public Class<?> getType() {
        if (this.clazz == null) {
            try {
                this.clazz = this.getInstance().getClass();
            }
            catch (InstantiationException ex) {
                log.error((Object)"Failed to instansiate object to detect type.", (Throwable)ex);
                return Object.class;
            }
        }
        return this.clazz;
    }

    @Override
    public Object getInstance() throws InstantiationException {
        try {
            if (overrideFactory != null) {
                return overrideFactory.getBean(this.beanName);
            }
            if (this.factory == null) {
                this.factory = this.getBeanFactory();
            }
            if (this.factory == null) {
                log.error((Object)"DWR can't find a spring config. See following info logs for solutions");
                log.info((Object)"- Option 1. In dwr.xml, <create creator='spring' ...> add <param name='location1' value='beans.xml'/> for each spring config file.");
                log.info((Object)"- Option 2. Use a spring org.springframework.web.context.ContextLoaderListener.");
                log.info((Object)"- Option 3. Call SpringCreator.setOverrideBeanFactory() from your web-app");
                throw new InstantiationException("DWR can't find a spring config. See the logs for solutions");
            }
            return this.factory.getBean(this.beanName);
        }
        catch (InstantiationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InstantiationException("Illegal Access to default constructor on " + this.clazz.getName() + " due to: " + ex);
        }
    }

    private BeanFactory getBeanFactory() {
        if (this.configLocation != null && this.configLocation.length > 0) {
            log.info((Object)("Spring BeanFactory via ClassPathXmlApplicationContext using " + this.configLocation.length + "configLocations."));
            return new ClassPathXmlApplicationContext(this.configLocation);
        }
        ServletContext srvCtx = ServerContextFactory.get().getServletContext();
        HttpServletRequest request = null;
        try {
            request = WebContextFactory.get().getHttpServletRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return request != null ? RequestContextUtils.getWebApplicationContext((ServletRequest)request, (ServletContext)srvCtx) : WebApplicationContextUtils.getWebApplicationContext((ServletContext)srvCtx);
    }

    @Deprecated
    public static void setXmlBeanFactory(BeanFactory factory) {
        overrideFactory = factory;
    }

    public static void setOverrideBeanFactory(BeanFactory factory) {
        overrideFactory = factory;
    }
}

