/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathScanner {
    private final String packageName;
    private final boolean recursive;
    private static final Log log = LogFactory.getLog(ClasspathScanner.class);

    public ClasspathScanner() {
        this(null, true);
    }

    public ClasspathScanner(String packageName) {
        this(packageName, false);
    }

    public ClasspathScanner(String packageName, boolean recursive) {
        this.recursive = recursive;
        if (packageName == null) {
            packageName = "";
        }
        if ((packageName = packageName.replace('.', '/')).endsWith("*")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        if (packageName.endsWith("/")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        this.packageName = packageName;
    }

    public Set<String> getClasses() {
        HashSet<String> classes = new HashSet<String>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String match = this.packageName;
            if (match == "/") {
                match = "";
            }
            Enumeration<URL> resources = classLoader.getResources(match + "/");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                String path = this.sanitizePath(resource.getFile());
                if (path == null || path.trim().length() <= 0) continue;
                if ("vfszip".equals(resource.getProtocol())) {
                    classes.addAll(this.getClassesFromVFS(path));
                    continue;
                }
                if (this.isJARPath(path)) {
                    classes.addAll(this.getClassesFromJAR(path));
                    continue;
                }
                classes.addAll(this.getClassesFromDirectory(path));
            }
        }
        catch (IOException ex) {
            log.warn((Object)"Failed to find any resources from classloader");
        }
        return classes;
    }

    protected boolean isJARPath(String path) {
        return path.indexOf("!") > 0 & path.indexOf(".jar") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Set<String> getClassesFromJAR(String path) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        String jarPath = path.substring(0, path.indexOf("!")).substring(path.indexOf(":") + 1);
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jarPath));
        try {
            JarEntry jarEntry;
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                this.addIfMatches(classes, jarEntry.getName());
            }
            Object var7_6 = null;
            if (null == jarFile) return classes;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == jarFile) throw throwable;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
        return classes;
    }

    protected Set<String> getClassesFromDirectory(String path) {
        HashSet<String> classes = new HashSet<String>();
        File directory = new File(path);
        if (directory.exists()) {
            for (String file : directory.list()) {
                File f = new File(directory, file);
                if (f.isFile()) {
                    this.addIfMatches(classes, path.substring(path.indexOf(this.packageName)) + file);
                    continue;
                }
                if (!this.recursive) continue;
                classes.addAll(this.getClassesFromDirectory(path + file + "/"));
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Set<String> getClassesFromVFS(String path) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        Pattern vfsPattern = Pattern.compile("(.*\\.[wej]ar)(/.*)");
        Matcher vfsMatcher = vfsPattern.matcher(path);
        if (!vfsMatcher.matches()) return classes;
        JarInputStream jarFile = new JarInputStream(new FileInputStream(vfsMatcher.group(1)));
        try {
            JarEntry jarEntry;
            Pattern vfsEntryPattern = this.recursive ? Pattern.compile(".*(" + this.packageName + ".*/)([^/]+)\\.class") : Pattern.compile(".*(" + this.packageName + "/)([^/]+)\\.class");
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                Matcher vfsEntryMatcher = vfsEntryPattern.matcher(jarEntry.getName());
                if (!vfsEntryMatcher.matches()) continue;
                classes.add(vfsEntryMatcher.group(1).replace("/", ".") + vfsEntryMatcher.group(2));
            }
            Object var10_9 = null;
            if (null == jarFile) return classes;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null == jarFile) throw throwable;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
        return classes;
    }

    protected void addIfMatches(Set<String> classes, String className) {
        if (className.startsWith(this.packageName) && className.endsWith(".class")) {
            boolean add;
            boolean bl = this.recursive ? true : (add = className.substring(this.packageName.length() + 1).indexOf("/") < 0);
            if (add) {
                classes.add(className.substring(0, className.length() - 6).replace('/', '.'));
            }
        }
    }

    protected String sanitizePath(String path) {
        String tmp = path;
        if (tmp.indexOf("%20") > 0) {
            tmp = tmp.replaceAll("%20", " ");
        }
        if (tmp.indexOf(":") >= 0 && tmp.startsWith("/")) {
            tmp = tmp.substring(1);
        }
        return tmp;
    }
}

