/*
 * Decompiled with CFR 0.152.
 */
package org.eispframework.minidao.aop;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.Ognl;
import ognl.OgnlException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eispframework.minidao.annotation.Arguments;
import org.eispframework.minidao.annotation.ResultType;
import org.eispframework.minidao.annotation.Sql;
import org.eispframework.minidao.hibernate.dao.IGenericBaseCommonDao;
import org.eispframework.minidao.pojo.MiniDaoPage;
import org.eispframework.minidao.spring.rowMapper.MiniColumnMapRowMapper;
import org.eispframework.minidao.spring.rowMapper.MiniColumnOriginalMapRowMapper;
import org.eispframework.minidao.util.FreemarkerParseFactory;
import org.eispframework.minidao.util.MiniDaoUtil;
import org.hibernate.engine.jdbc.internal.BasicFormatterImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;

public class MiniDaoHandler
implements MethodInterceptor {
    private static final Logger logger = Logger.getLogger(MiniDaoHandler.class);
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private IGenericBaseCommonDao miniDaoHiberCommonDao;
    private BasicFormatterImpl formatter = new BasicFormatterImpl();
    private String UPPER_KEY = "upper";
    private String LOWER_KEY = "lower";
    private String keyType = "origin";
    private boolean formatSql = false;
    private boolean showSql = false;
    private String dbType;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object[] args = methodInvocation.getArguments();
        ResultType arguments = method.getAnnotation(ResultType.class);
        Object returnObj = null;
        String templateSql = null;
        HashMap<String, Object> sqlParamsMap = new HashMap<String, Object>();
        MiniDaoPage pageSetting = new MiniDaoPage();
        if (!MiniDaoUtil.isAbstract(method)) {
            return methodInvocation.proceed();
        }
        HashMap rs = new HashMap();
        if (this.miniDaoHiber(rs, method, args)) {
            return rs.get("returnObj");
        }
        templateSql = this.installDaoMetaData(pageSetting, method, sqlParamsMap, args);
        String executeSql = this.parseSqlTemplate(method, templateSql, sqlParamsMap);
        Map<String, Object> sqlMap = this.installPlaceholderSqlParam(executeSql, sqlParamsMap);
        returnObj = this.getReturnMinidaoResult(this.dbType, pageSetting, this.jdbcTemplate, method, executeSql, sqlMap);
        if (this.showSql) {
            logger.info((Object)("MiniDao-SQL:\n\n" + (this.formatSql ? this.formatter.format(executeSql) : executeSql) + "\n"));
        }
        return returnObj;
    }

    private boolean miniDaoHiber(Map rs, Method method, Object[] args) {
        if ("saveByHiber".equals(method.getName())) {
            this.miniDaoHiberCommonDao.save(args[0]);
            return true;
        }
        if ("getByIdHiber".equals(method.getName())) {
            Class clz = (Class)args[0];
            rs.put("returnObj", this.miniDaoHiberCommonDao.get(clz, (Serializable)((Object)args[1].toString())));
            return true;
        }
        if ("getByEntityHiber".equals(method.getName())) {
            rs.put("returnObj", this.miniDaoHiberCommonDao.get(args[0]));
            return true;
        }
        if ("updateByHiber".equals(method.getName())) {
            this.miniDaoHiberCommonDao.saveOrUpdate(args[0]);
            return true;
        }
        if ("deleteByHiber".equals(method.getName())) {
            this.miniDaoHiberCommonDao.delete(args[0]);
            return true;
        }
        if ("deleteByIdHiber".equals(method.getName())) {
            Class clz = (Class)args[0];
            this.miniDaoHiberCommonDao.deleteEntityById(clz, (Serializable)((Object)args[1].toString()));
            return true;
        }
        if ("listByHiber".equals(method.getName())) {
            rs.put("returnObj", this.miniDaoHiberCommonDao.loadAll(args[0]));
            return true;
        }
        return false;
    }

    private String parseSqlTemplate(Method method, String templateSql, Map<String, Object> sqlParamsMap) {
        FreemarkerParseFactory freemarkerUtil = new FreemarkerParseFactory();
        String executeSql = null;
        if (StringUtils.isNotEmpty((String)templateSql)) {
            executeSql = freemarkerUtil.parseTemplateContent(templateSql, sqlParamsMap);
        } else {
            String sqlTempletPath = method.getDeclaringClass().getName().replace(".", "/").replace("/dao/", "/sql/") + "_" + method.getName() + ".sql";
            if (!freemarkerUtil.isExistTemplate(sqlTempletPath)) {
                sqlTempletPath = method.getDeclaringClass().getName().replace(".", "/") + "_" + method.getName() + ".sql";
            }
            logger.debug((Object)("MiniDao-SQL-Path:" + sqlTempletPath));
            executeSql = new FreemarkerParseFactory().parseTemplate(sqlTempletPath, sqlParamsMap);
        }
        return this.getSqlText(executeSql);
    }

    private String getSqlText(String sql) {
        Pattern p = Pattern.compile("(?ms)/\\*.*?\\*/|^\\s*//.*?$");
        sql = p.matcher(sql).replaceAll("");
        return sql.replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("\\s{1,}", " ").trim();
    }

    private Map<String, Object> installPlaceholderSqlParam(String executeSql, Map sqlParamsMap) throws OgnlException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String regEx = ":[ tnx0Bfr]*[0-9a-z.A-Z]+";
        Pattern pat = Pattern.compile(regEx);
        Matcher m = pat.matcher(executeSql);
        while (m.find()) {
            logger.debug((Object)(" Match [" + m.group() + "] at positions " + m.start() + "-" + (m.end() - 1)));
            String ognl_key = m.group().replace(":", "").trim();
            map.put(ognl_key, Ognl.getValue((String)ognl_key, (Object)sqlParamsMap));
        }
        return map;
    }

    private Object getReturnMinidaoResult(String dbType, MiniDaoPage pageSetting, JdbcTemplate jdbcTemplate, Method method, String executeSql, Map<String, Object> paramMap) {
        String methodName = method.getName();
        if (MiniDaoHandler.checkActiveKey(methodName)) {
            if (paramMap != null) {
                return this.namedParameterJdbcTemplate.update(executeSql, paramMap);
            }
            return jdbcTemplate.update(executeSql);
        }
        if (MiniDaoHandler.checkBatchKey(methodName)) {
            return this.batchUpdate(jdbcTemplate, executeSql);
        }
        Class<Object> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            Number number = (Number)jdbcTemplate.queryForObject(executeSql, BigDecimal.class);
            if ("int".equals(returnType.getCanonicalName())) {
                return number.intValue();
            }
            if ("long".equals(returnType.getCanonicalName())) {
                return number.longValue();
            }
            if ("double".equals(returnType.getCanonicalName())) {
                return number.doubleValue();
            }
        } else {
            if (returnType.isAssignableFrom(List.class) || returnType.isAssignableFrom(MiniDaoPage.class)) {
                List list;
                int page = pageSetting.getPage();
                int rows = pageSetting.getRows();
                if (page != 0 && rows != 0) {
                    if (returnType.isAssignableFrom(MiniDaoPage.class)) {
                        if (paramMap != null) {
                            pageSetting.setTotal((Integer)this.namedParameterJdbcTemplate.queryForObject(this.getCountSql(executeSql), paramMap, Integer.class));
                        } else {
                            pageSetting.setTotal((Integer)jdbcTemplate.queryForObject(executeSql, Integer.class));
                        }
                    }
                    executeSql = MiniDaoUtil.createPageSql(dbType, executeSql, page, rows);
                }
                ResultType resultType = method.getAnnotation(ResultType.class);
                String[] values = null;
                if (resultType != null) {
                    values = resultType.value();
                }
                if (values == null || values.length == 0 || "java.util.Map".equals(values[0])) {
                    list = paramMap != null ? this.namedParameterJdbcTemplate.query(executeSql, paramMap, this.getColumnMapRowMapper()) : jdbcTemplate.query(executeSql, this.getColumnMapRowMapper());
                } else {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(values[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    list = paramMap != null ? this.namedParameterJdbcTemplate.query(executeSql, paramMap, (RowMapper)ParameterizedBeanPropertyRowMapper.newInstance(clazz)) : jdbcTemplate.query(executeSql, (RowMapper)ParameterizedBeanPropertyRowMapper.newInstance(clazz));
                }
                if (returnType.isAssignableFrom(MiniDaoPage.class)) {
                    pageSetting.setResults(list);
                    return pageSetting;
                }
                return list;
            }
            if (returnType.isAssignableFrom(Map.class)) {
                if (paramMap != null) {
                    return (Map)this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, this.getColumnMapRowMapper());
                }
                return (Map)jdbcTemplate.queryForObject(executeSql, this.getColumnMapRowMapper());
            }
            if (returnType.isAssignableFrom(String.class)) {
                try {
                    if (paramMap != null) {
                        return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, String.class);
                    }
                    return jdbcTemplate.queryForObject(executeSql, String.class);
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            }
            if (MiniDaoUtil.isWrapClass(returnType)) {
                try {
                    if (paramMap != null) {
                        return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, returnType);
                    }
                    return jdbcTemplate.queryForObject(executeSql, returnType);
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            }
            ParameterizedBeanPropertyRowMapper rm = ParameterizedBeanPropertyRowMapper.newInstance(returnType);
            try {
                if (paramMap != null) {
                    return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, (RowMapper)rm);
                }
                return jdbcTemplate.queryForObject(executeSql, (RowMapper)rm);
            }
            catch (EmptyResultDataAccessException e) {
                return null;
            }
        }
        return null;
    }

    private int[] batchUpdate(JdbcTemplate jdbcTemplate, String executeSql) {
        String[] sqls = executeSql.split(";");
        if (sqls.length < 100) {
            return jdbcTemplate.batchUpdate(sqls);
        }
        int[] result = new int[sqls.length];
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < sqls.length; ++i) {
            sqlList.add(sqls[i]);
            if (i % 100 != 0) continue;
            this.addResulArray(result, i + 1, jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
            sqlList.clear();
        }
        this.addResulArray(result, sqls.length, jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
        return result;
    }

    private String getCountSql(String sql) {
        return "select count(0) from (" + sql + ") tmp_count";
    }

    private void addResulArray(int[] result, int index, int[] arr) {
        for (int result[index - length + i] : arr) {
        }
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    private String installDaoMetaData(MiniDaoPage pageSetting, Method method, Map<String, Object> sqlParamsMap, Object[] args) throws Exception {
        String templateSql = null;
        boolean arguments_flag = method.isAnnotationPresent(Arguments.class);
        if (arguments_flag) {
            Arguments arguments = method.getAnnotation(Arguments.class);
            logger.debug((Object)("@Arguments------------------------------------------" + Arrays.toString(arguments.value())));
            if (arguments.value().length > args.length) {
                throw new Exception("[\u6ce8\u91ca\u6807\u7b7e]\u53c2\u6570\u6570\u76ee\uff0c\u4e0d\u80fd\u5927\u4e8e[\u65b9\u6cd5\u53c2\u6570]\u53c2\u6570\u6570\u76ee");
            }
            int args_num = 0;
            for (String v : arguments.value()) {
                if (v.equalsIgnoreCase("page")) {
                    pageSetting.setPage(Integer.parseInt(args[args_num].toString()));
                }
                if (v.equalsIgnoreCase("rows")) {
                    pageSetting.setRows(Integer.parseInt(args[args_num].toString()));
                }
                sqlParamsMap.put(v, args[args_num]);
                ++args_num;
            }
        } else {
            if (args.length > 1) {
                throw new Exception("\u65b9\u6cd5\u53c2\u6570\u6570\u76ee>=2\uff0c\u65b9\u6cd5\u5fc5\u987b\u4f7f\u7528\u6ce8\u91ca\u6807\u7b7e@Arguments");
            }
            if (args.length == 1) {
                sqlParamsMap.put("dto", args[0]);
            }
        }
        if (method.isAnnotationPresent(Sql.class)) {
            Sql sql = method.getAnnotation(Sql.class);
            if (StringUtils.isNotEmpty((String)sql.value())) {
                templateSql = sql.value();
            }
            logger.debug((Object)("@Sql------------------------------------------" + sql.value()));
        }
        return templateSql;
    }

    private static boolean checkActiveKey(String methodName) {
        String[] keys;
        for (String s : keys = "insert,add,create,update,modify,store,delete,remove,merge".split(",")) {
            if (!methodName.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkBatchKey(String methodName) {
        String[] keys;
        for (String s : keys = "batch".split(",")) {
            if (!methodName.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        if (this.getKeyType().equalsIgnoreCase(this.LOWER_KEY)) {
            return new MiniColumnMapRowMapper();
        }
        if (this.getKeyType().equalsIgnoreCase(this.UPPER_KEY)) {
            return new ColumnMapRowMapper();
        }
        return new MiniColumnOriginalMapRowMapper();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public IGenericBaseCommonDao getMiniDaoHiberCommonDao() {
        return this.miniDaoHiberCommonDao;
    }

    public void setMiniDaoHiberCommonDao(IGenericBaseCommonDao miniDaoHiberCommonDao) {
        this.miniDaoHiberCommonDao = miniDaoHiberCommonDao;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}

