/*
 * Decompiled with CFR 0.152.
 */
package org.eispframework.minidao.hibernate.dao.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.eispframework.minidao.hibernate.dao.IGenericBaseCommonDao;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
@Transactional
public class GenericBaseCommonDao<T, PK extends Serializable>
implements IGenericBaseCommonDao {
    private static final Logger logger = Logger.getLogger(GenericBaseCommonDao.class);
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public Session getSession() {
        try {
            return this.sessionFactory.getCurrentSession();
        }
        catch (Exception e) {
            return this.sessionFactory.openSession();
        }
    }

    @Override
    public <T> void save(T entity) {
        try {
            this.getSession().save(entity);
            this.getSession().flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u4fdd\u5b58\u5b9e\u4f53\u6210\u529f," + entity.getClass().getName()));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"\u4fdd\u5b58\u5b9e\u4f53\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        try {
            this.getSession().saveOrUpdate(entity);
            this.getSession().flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6dfb\u52a0\u6216\u66f4\u65b0\u6210\u529f," + entity.getClass().getName()));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"\u6dfb\u52a0\u6216\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void delete(T entity) {
        try {
            this.getSession().delete(entity);
            this.getSession().flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5220\u9664\u6210\u529f," + entity.getClass().getName()));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"\u5220\u9664\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> T findUniqueByProperty(Class<T> entityClass, String propertyName, Object value) {
        Assert.hasText((String)propertyName);
        return (T)this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).uniqueResult();
    }

    private <T> Criteria createCriteria(Class<T> entityClass, boolean isAsc, Criterion ... criterions) {
        Criteria criteria = this.createCriteria(entityClass, criterions);
        if (isAsc) {
            criteria.addOrder(Order.asc((String)"asc"));
        } else {
            criteria.addOrder(Order.desc((String)"desc"));
        }
        return criteria;
    }

    private <T> Criteria createCriteria(Class<T> entityClass, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        return criteria;
    }

    public <T> List<T> findByProperty(Class<T> entityClass, String propertyName, Object value) {
        Assert.hasText((String)propertyName);
        return this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).list();
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id) {
        return (T)this.getSession().get(entityClass, id);
    }

    @Override
    public <T> T get(T entitie) {
        Criteria executableCriteria = this.getSession().createCriteria(entitie.getClass());
        executableCriteria.add((Criterion)Example.create(entitie));
        if (executableCriteria.list().size() == 0) {
            return null;
        }
        return (T)executableCriteria.list().get(0);
    }

    @Override
    public <T> List<T> loadAll(T entitie) {
        Criteria executableCriteria = this.getSession().createCriteria(entitie.getClass());
        executableCriteria.add((Criterion)Example.create(entitie));
        return executableCriteria.list();
    }

    @Override
    public <T> void deleteEntityById(Class entityName, Serializable id) {
        this.delete(this.get(entityName, id));
        this.getSession().flush();
    }
}

