/*
 * Decompiled with CFR 0.152.
 */
package org.eispframework.minidao.spring.map;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class MiniDaoLinkedMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private final Locale locale;

    public MiniDaoLinkedMap() {
        this((Locale)null);
    }

    public MiniDaoLinkedMap(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public MiniDaoLinkedMap(int initialCapacity) {
        this(initialCapacity, null);
    }

    public MiniDaoLinkedMap(int initialCapacity, Locale locale) {
        super(initialCapacity);
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(this.convertKey(key), value);
    }

    @Override
    public void putAll(Map map) {
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(this.convertKey((String)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && super.containsKey(this.convertKey((String)key));
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return super.get(this.convertKey((String)key));
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String) {
            return super.remove(this.convertKey((String)key));
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
    }

    protected String convertKey(String key) {
        return key.toLowerCase(this.locale);
    }
}

