/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupObjectsInitializer
implements ObjectsInitializer {
    private static final Logger log = LoggerFactory.make();
    public static final LookupObjectsInitializer INSTANCE = new LookupObjectsInitializer();

    private LookupObjectsInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager, Session session) {
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            log.trace("No object to initialize", (Object)maxResults);
            return;
        }
        for (EntityInfo entityInfo : entityInfos) {
            ObjectLoaderHelper.load(entityInfo, session);
        }
        log.trace("Initialized {} objects by lookup method.", (Object)maxResults);
    }
}

