/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.oauth.services.OAuthRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public final class OAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthUtils.class);

    private OAuthUtils() {
    }

    public static ModelAndView writeTextError(HttpServletResponse response, String error, int status) {
        return OAuthUtils.writeText(response, "error=" + error, status);
    }

    public static ModelAndView writeText(HttpServletResponse response, String text, int status) {
        try {
            PrintWriter printWriter = response.getWriter();
            response.setStatus(status);
            printWriter.print(text);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to response", (Throwable)e);
        }
        return null;
    }

    public static ModelAndView redirectToError(String url, String error) {
        String useUrl = url;
        if (StringUtils.isBlank((String)useUrl)) {
            useUrl = "/";
        }
        return OAuthUtils.redirectTo(OAuthUtils.addParameter(useUrl, "error", error));
    }

    public static ModelAndView redirectTo(String url) {
        return new ModelAndView((View)new RedirectView(url));
    }

    public static String addParameter(String url, String name, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        if (url.indexOf("?") >= 0) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(name);
        sb.append("=");
        if (value != null) {
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return sb.toString();
    }

    public static OAuthRegisteredService getRegisteredOAuthService(ServicesManager servicesManager, String clientId) {
        for (RegisteredService aService : servicesManager.getAllServices()) {
            OAuthRegisteredService service;
            if (!(aService instanceof OAuthRegisteredService) || !(service = (OAuthRegisteredService)aService).getClientId().equals(clientId)) continue;
            return service;
        }
        return null;
    }
}

