/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.export.base.ExcelExportBase;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;
import org.jeecgframework.poi.util.POIPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportServer
extends ExcelExportBase {
    private static final Logger logger = LoggerFactory.getLogger(ExcelExportServer.class);
    private static final short cellFormat = HSSFDataFormat.getBuiltinFormat((String)"TEXT");
    private final int MAX_NUM = 60000;

    public void createSheet(HSSFWorkbook workbook, ExportParams entity, Class<?> pojoClass, Collection<?> dataSet) {
        if (logger.isDebugEnabled()) {
            logger.debug("Excel export start ,class is {}", pojoClass);
        }
        if (workbook == null || entity == null || pojoClass == null || dataSet == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        HSSFSheet sheet = null;
        try {
            sheet = workbook.createSheet(entity.getSheetName());
        }
        catch (Exception e) {
            sheet = workbook.createSheet();
        }
        try {
            int index;
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            Map<String, HSSFCellStyle> styles = this.createStyles(workbook);
            Drawing patriarch = sheet.createDrawingPatriarch();
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity());
            }
            Field[] fileds = POIPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = etarget == null ? null : etarget.value();
            this.getAllExcelField(entity.getExclusions(), targetId, fileds, excelParams, pojoClass, null);
            this.sortAllParams(excelParams);
            int titleHeight = index = this.createHeaderAndTitle(entity, (Sheet)sheet, workbook, excelParams);
            this.setCellWith(excelParams, (Sheet)sheet);
            short rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
            Iterator<?> its = dataSet.iterator();
            ArrayList tempList = new ArrayList();
            while (its.hasNext()) {
                Object t = its.next();
                index += this.createCells(patriarch, index, t, excelParams, (Sheet)sheet, (Workbook)workbook, styles, rowHeight);
                tempList.add(t);
                if (index >= 60000) break;
            }
            this.mergeCells((Sheet)sheet, excelParams, titleHeight);
            its = dataSet.iterator();
            int i = 0;
            int le = tempList.size();
            while (i < le) {
                its.next();
                its.remove();
                ++i;
            }
            if (dataSet.size() > 0) {
                this.createSheet(workbook, entity, pojoClass, dataSet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    private ExcelExportEntity indexExcelEntity() {
        ExcelExportEntity entity = new ExcelExportEntity();
        entity.setOrderNum(0);
        entity.setName("\u5e8f\u53f7");
        entity.setWidth(10);
        entity.setFormat("isAddIndex");
        return entity;
    }

    private int createHeaderAndTitle(ExportParams entity, Sheet sheet, HSSFWorkbook workbook, List<ExcelExportEntity> excelParams) {
        int rows = 0;
        int feildWidth = this.getFieldWidth(excelParams);
        if (entity.getTitle() != null) {
            rows += this.createHeaderRow(entity, sheet, workbook, feildWidth);
        }
        rows += this.createTitleRow(entity, sheet, workbook, rows, excelParams);
        sheet.createFreezePane(0, rows, 0, rows);
        return rows;
    }

    private int createTitleRow(ExportParams title, Sheet sheet, HSSFWorkbook workbook, int index, List<ExcelExportEntity> excelParams) {
        Row row = sheet.createRow(index);
        int rows = this.getRowNums(excelParams);
        row.setHeight((short)450);
        Row listRow = null;
        if (rows == 2) {
            listRow = sheet.createRow(index + 1);
            listRow.setHeight((short)450);
        }
        int cellIndex = 0;
        HSSFCellStyle titleStyle = this.getTitleStyle(workbook, title);
        int i = 0;
        int exportFieldTitleSize = excelParams.size();
        while (i < exportFieldTitleSize) {
            ExcelExportEntity entity = excelParams.get(i);
            this.createStringCell(row, cellIndex, entity.getName(), (CellStyle)titleStyle, entity);
            if (entity.getList() != null) {
                List<ExcelExportEntity> sTitel = entity.getList();
                sheet.addMergedRegion(new CellRangeAddress(index, index, cellIndex, cellIndex + sTitel.size() - 1));
                int j = 0;
                int size = sTitel.size();
                while (j < size) {
                    this.createStringCell(listRow, cellIndex, sTitel.get(j).getName(), (CellStyle)titleStyle, entity);
                    ++cellIndex;
                    ++j;
                }
            } else if (rows == 2) {
                sheet.addMergedRegion(new CellRangeAddress(index, index + 1, cellIndex, cellIndex));
            }
            ++cellIndex;
            ++i;
        }
        return rows;
    }

    private int getRowNums(List<ExcelExportEntity> excelParams) {
        int i = 0;
        while (i < excelParams.size()) {
            if (excelParams.get(i).getList() != null) {
                return 2;
            }
            ++i;
        }
        return 1;
    }

    public int createHeaderRow(ExportParams entity, Sheet sheet, HSSFWorkbook workbook, int feildWidth) {
        Row row = sheet.createRow(0);
        row.setHeight(entity.getTitleHeight());
        this.createStringCell(row, 0, entity.getTitle(), (CellStyle)this.getHeaderStyle(workbook, entity), null);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, feildWidth));
        if (entity.getSecondTitle() != null) {
            row = sheet.createRow(1);
            row.setHeight(entity.getSecondTitleHeight());
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment((short)3);
            this.createStringCell(row, 0, entity.getSecondTitle(), (CellStyle)style, null);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, feildWidth));
            return 2;
        }
        return 1;
    }

    public HSSFCellStyle getTitleStyle(HSSFWorkbook workbook, ExportParams entity) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillForegroundColor(entity.getHeaderColor());
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        titleStyle.setFillPattern((short)1);
        titleStyle.setWrapText(true);
        return titleStyle;
    }

    public HSSFCellStyle getHeaderStyle(HSSFWorkbook workbook, ExportParams entity) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)24);
        titleStyle.setFont((Font)font);
        titleStyle.setFillForegroundColor(entity.getColor());
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        return titleStyle;
    }

    public HSSFCellStyle getTwoStyle(HSSFWorkbook workbook, boolean isWarp) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setFillForegroundColor((short)41);
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setDataFormat(cellFormat);
        if (isWarp) {
            style.setWrapText(true);
        }
        return style;
    }

    public HSSFCellStyle getOneStyle(HSSFWorkbook workbook, boolean isWarp) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setDataFormat(cellFormat);
        if (isWarp) {
            style.setWrapText(true);
        }
        return style;
    }

    private Map<String, HSSFCellStyle> createStyles(HSSFWorkbook workbook) {
        HashMap<String, HSSFCellStyle> map = new HashMap<String, HSSFCellStyle>();
        map.put("one", this.getOneStyle(workbook, false));
        map.put("oneWrap", this.getOneStyle(workbook, true));
        map.put("two", this.getTwoStyle(workbook, false));
        map.put("twoWrap", this.getTwoStyle(workbook, true));
        return map;
    }

    @Override
    public CellStyle getStyles(Map<String, HSSFCellStyle> map, boolean needOne, boolean isWrap) {
        if (needOne && isWrap) {
            return (CellStyle)map.get("oneWrap");
        }
        if (needOne) {
            return (CellStyle)map.get("one");
        }
        if (!needOne && isWrap) {
            return (CellStyle)map.get("twoWrap");
        }
        return (CellStyle)map.get("two");
    }
}

