/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export.base;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.entity.params.MergeEntity;
import org.jeecgframework.poi.excel.export.base.ExportBase;
import org.jeecgframework.poi.util.POIPublicUtil;

public abstract class ExcelExportBase
extends ExportBase {
    private int currentIndex = 0;

    public void mergeCells(Sheet sheet, List<ExcelExportEntity> excelParams, int titleHeight) {
        Map<Integer, int[]> mergeMap = this.getMergeDataMap(excelParams);
        HashMap<Integer, MergeEntity> mergeDataMap = new HashMap<Integer, MergeEntity>();
        if (mergeMap.size() == 0) {
            return;
        }
        Set<Integer> sets = mergeMap.keySet();
        int i = titleHeight;
        while (i <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i);
            for (Integer index : sets) {
                if (row.getCell(index.intValue()) == null) {
                    ((MergeEntity)mergeDataMap.get(index)).setEndRow(i);
                    continue;
                }
                String text = row.getCell(index.intValue()).getStringCellValue();
                if (StringUtils.isNotEmpty((String)text)) {
                    this.hanlderMergeCells(index, i, text, mergeDataMap, sheet, row.getCell(index.intValue()), mergeMap.get(index));
                    continue;
                }
                this.mergeCellOrContinue(index, mergeDataMap, sheet);
            }
            ++i;
        }
        for (Integer index : sets) {
            sheet.addMergedRegion(new CellRangeAddress(((MergeEntity)mergeDataMap.get(index)).getStartRow(), ((MergeEntity)mergeDataMap.get(index)).getEndRow(), index.intValue(), index.intValue()));
        }
    }

    private void mergeCellOrContinue(Integer index, Map<Integer, MergeEntity> mergeDataMap, Sheet sheet) {
        if (mergeDataMap.containsKey(index) && mergeDataMap.get(index).getEndRow() != mergeDataMap.get(index).getStartRow()) {
            sheet.addMergedRegion(new CellRangeAddress(mergeDataMap.get(index).getStartRow(), mergeDataMap.get(index).getEndRow(), index.intValue(), index.intValue()));
            mergeDataMap.remove(index);
        }
    }

    private void hanlderMergeCells(Integer index, int rowNum, String text, Map<Integer, MergeEntity> mergeDataMap, Sheet sheet, Cell cell, int[] delys) {
        if (mergeDataMap.containsKey(index)) {
            if (this.checkIsEqualByCellContents(mergeDataMap.get(index), text, cell, delys, rowNum)) {
                mergeDataMap.get(index).setEndRow(rowNum);
            } else {
                sheet.addMergedRegion(new CellRangeAddress(mergeDataMap.get(index).getStartRow(), mergeDataMap.get(index).getEndRow(), index.intValue(), index.intValue()));
                mergeDataMap.put(index, this.createMergeEntity(text, rowNum, cell, delys));
            }
        } else {
            mergeDataMap.put(index, this.createMergeEntity(text, rowNum, cell, delys));
        }
    }

    private String getCellNotNullText(Cell cell, int index, int rowNum) {
        String temp = cell.getRow().getCell(index).getStringCellValue();
        while (StringUtils.isEmpty((String)temp)) {
            temp = cell.getRow().getSheet().getRow(--rowNum).getCell(index).getStringCellValue();
        }
        return temp;
    }

    private MergeEntity createMergeEntity(String text, int rowNum, Cell cell, int[] delys) {
        MergeEntity mergeEntity = new MergeEntity(text, rowNum, rowNum);
        ArrayList<String> list = new ArrayList<String>(delys.length);
        mergeEntity.setRelyList(list);
        int i = 0;
        while (i < delys.length) {
            list.add(this.getCellNotNullText(cell, delys[i], rowNum));
            ++i;
        }
        return mergeEntity;
    }

    private boolean checkIsEqualByCellContents(MergeEntity mergeEntity, String text, Cell cell, int[] delys, int rowNum) {
        if (delys == null || delys.length == 0) {
            return mergeEntity.getText().equals(text);
        }
        if (mergeEntity.getText().equals(text)) {
            int i = 0;
            while (i > delys.length) {
                if (!this.getCellNotNullText(cell, delys[i], rowNum).equals(mergeEntity.getRelyList().get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private Map<Integer, int[]> getMergeDataMap(List<ExcelExportEntity> excelParams) {
        HashMap<Integer, int[]> mergeMap = new HashMap<Integer, int[]>();
        int i = 0;
        for (ExcelExportEntity entity : excelParams) {
            if (entity.isMergeVertical()) {
                mergeMap.put(i, entity.getMergeRely());
            }
            if (entity.getList() != null) {
                for (ExcelExportEntity inner : entity.getList()) {
                    if (inner.isMergeVertical()) {
                        mergeMap.put(i, inner.getMergeRely());
                    }
                    ++i;
                }
                continue;
            }
            ++i;
        }
        return mergeMap;
    }

    public int createCells(Drawing patriarch, int index, Object t, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook, Map<String, HSSFCellStyle> styles, short rowHeight) throws Exception {
        ExcelExportEntity entity;
        Row row = sheet.createRow(index);
        row.setHeight(rowHeight);
        int maxHeight = 1;
        int cellNum = 0;
        int indexKey = this.createIndexCell(row, styles, index, excelParams.get(0));
        cellNum += indexKey;
        int k = indexKey;
        int paramSize = excelParams.size();
        while (k < paramSize) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection list = (Collection)entity.getMethod().invoke(t, new Object[0]);
                int listC = 0;
                for (Object obj : list) {
                    this.createListCells(patriarch, index + listC, cellNum, obj, entity.getList(), sheet, workbook, styles);
                    ++listC;
                }
                cellNum += entity.getList().size();
                if (list != null && list.size() > maxHeight) {
                    maxHeight = list.size();
                }
            } else {
                Object value = this.getCellValue(entity, t);
                if (entity.getType() == 1) {
                    this.createStringCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(styles, false, entity.isWrap()) : this.getStyles(styles, true, entity.isWrap()), entity);
                } else {
                    this.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), t);
                }
            }
            ++k;
        }
        cellNum = 0;
        k = indexKey;
        paramSize = excelParams.size();
        while (k < paramSize) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                cellNum += entity.getList().size();
            } else if (entity.isNeedMerge()) {
                sheet.addMergedRegion(new CellRangeAddress(index, index + maxHeight - 1, cellNum, cellNum));
                ++cellNum;
            }
            ++k;
        }
        return maxHeight;
    }

    private int createIndexCell(Row row, Map<String, HSSFCellStyle> styles, int index, ExcelExportEntity excelExportEntity) {
        if (excelExportEntity.getName().equals("\u5e8f\u53f7") && excelExportEntity.getFormat().equals("isAddIndex")) {
            this.createStringCell(row, 0, String.valueOf(this.currentIndex), index % 2 == 0 ? this.getStyles(styles, false, false) : this.getStyles(styles, true, false), null);
            ++this.currentIndex;
            return 1;
        }
        return 0;
    }

    public CellStyle getStyles(Map<String, HSSFCellStyle> styles, boolean b, boolean wrap) {
        return null;
    }

    public void createListCells(Drawing patriarch, int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook, Map<String, HSSFCellStyle> styles) throws Exception {
        Row row;
        if (sheet.getRow(index) == null) {
            row = sheet.createRow(index);
            row.setHeight(this.getRowHeight(excelParams));
        } else {
            row = sheet.getRow(index);
        }
        int k = 0;
        int paramSize = excelParams.size();
        while (k < paramSize) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = this.getCellValue(entity, obj);
            if (entity.getType() == 1) {
                this.createStringCell(row, cellNum++, value == null ? "" : value.toString(), row.getRowNum() % 2 == 0 ? this.getStyles(styles, false, entity.isWrap()) : this.getStyles(styles, true, entity.isWrap()), entity);
            } else {
                this.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), obj);
            }
            ++k;
        }
    }

    public void setCellWith(List<ExcelExportEntity> excelParams, Sheet sheet) {
        int index = 0;
        int i = 0;
        while (i < excelParams.size()) {
            if (excelParams.get(i).getList() != null) {
                List<ExcelExportEntity> list = excelParams.get(i).getList();
                int j = 0;
                while (j < list.size()) {
                    sheet.setColumnWidth(index, 256 * list.get(j).getWidth());
                    ++index;
                    ++j;
                }
            } else {
                sheet.setColumnWidth(index, 256 * excelParams.get(i).getWidth());
                ++index;
            }
            ++i;
        }
    }

    public void createStringCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity) {
        Cell cell = row.createCell(index);
        HSSFRichTextString Rtext = new HSSFRichTextString(text);
        cell.setCellValue((RichTextString)Rtext);
        if (style != null) {
            cell.setCellStyle(style);
        }
    }

    public void createImageCell(Drawing patriarch, ExcelExportEntity entity, Row row, int i, String string, Object obj) throws Exception {
        row.setHeight((short)(50 * entity.getHeight()));
        row.createCell(i);
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)i, row.getRowNum(), (short)(i + 1), row.getRowNum() + 1);
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (entity.getExportImageType() == 1) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            try {
                String path = POIPublicUtil.getWebRootPath(string);
                path = path.replace("WEB-INF/classes/", "");
                path = path.replace("file:/", "");
                BufferedImage bufferImg = ImageIO.read(new File(path));
                ImageIO.write((RenderedImage)bufferImg, string.substring(string.indexOf(".") + 1, string.length()), byteArrayOut);
                byte[] value = byteArrayOut.toByteArray();
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, this.getImageType(value)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            byte[] value = (byte[])(entity.getMethods() != null ? this.getFieldBySomeMethod(entity.getMethods(), obj) : entity.getMethod().invoke(obj, new Object[0]));
            if (value != null) {
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, this.getImageType(value)));
            }
        }
    }

    public int getImageType(byte[] value) {
        String type = POIPublicUtil.getFileExtendName(value);
        if (type.equalsIgnoreCase("JPG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }

    public int getFieldWidth(List<ExcelExportEntity> excelParams) {
        int length = -1;
        for (ExcelExportEntity entity : excelParams) {
            length += entity.getList() != null ? entity.getList().size() : 1;
        }
        return length;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }
}

