/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export.template;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.cache.ExcelCache;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.TemplateExportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.export.base.ExcelExportBase;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;
import org.jeecgframework.poi.util.POIPublicUtil;

public final class ExcelExportOfTemplateUtil
extends ExcelExportBase {
    public Workbook createExcleByTemplate(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        if (params == null || map == null || StringUtils.isEmpty((String)params.getTemplateUrl())) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            wb = this.getCloneWorkBook(params);
            if (StringUtils.isNotEmpty((String)params.getSheetName())) {
                wb.setSheetName(0, params.getSheetName());
            }
            this.parseTemplate(wb.getSheetAt(0), map);
            if (dataSet != null) {
                this.dataHanlder = params.getDataHanlder();
                if (this.dataHanlder != null) {
                    this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
                }
                this.addDataToSheet(params, pojoClass, dataSet, wb.getSheetAt(0), wb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return wb;
    }

    private Workbook getCloneWorkBook(TemplateExportParams params) throws Exception {
        return ExcelCache.getWorkbook(params.getTemplateUrl(), params.getSheetNum());
    }

    private void addDataToSheet(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Sheet sheet, Workbook workbook) throws Exception {
        int index;
        Map<String, Integer> titlemap = this.getTitleMap(params, sheet);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Field[] fileds = POIPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.value();
        }
        ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
        this.getAllExcelField(null, targetId, fileds, excelParams, pojoClass, null);
        this.sortAndFilterExportField(excelParams, titlemap);
        short rowHeight = this.getRowHeight(excelParams);
        Iterator<?> its = dataSet.iterator();
        int titleHeight = index = sheet.getLastRowNum() + 1;
        while (its.hasNext()) {
            Object t = its.next();
            index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, null, rowHeight);
        }
        this.mergeCells(sheet, excelParams, titleHeight);
    }

    private void sortAndFilterExportField(List<ExcelExportEntity> excelParams, Map<String, Integer> titlemap) {
        int i = excelParams.size() - 1;
        while (i >= 0) {
            if (excelParams.get(i).getList() != null && excelParams.get(i).getList().size() > 0) {
                this.sortAndFilterExportField(excelParams.get(i).getList(), titlemap);
                if (excelParams.get(i).getList().size() == 0) {
                    excelParams.remove(i);
                } else {
                    excelParams.get(i).setOrderNum(i);
                }
            } else if (titlemap.containsKey(excelParams.get(i).getName())) {
                excelParams.get(i).setOrderNum(i);
            } else {
                excelParams.remove(i);
            }
            --i;
        }
        this.sortAllParams(excelParams);
    }

    private Map<String, Integer> getTitleMap(TemplateExportParams params, Sheet sheet) {
        Row row = null;
        HashMap<String, Integer> titlemap = new HashMap<String, Integer>();
        int j = 0;
        while (j < params.getHeadingRows()) {
            row = sheet.getRow(j + params.getHeadingStartRow());
            Iterator cellTitle = row.cellIterator();
            int i = row.getFirstCellNum();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (!StringUtils.isEmpty((String)value)) {
                    titlemap.put(value, i);
                }
                ++i;
            }
            ++j;
        }
        return titlemap;
    }

    private void parseTemplate(Sheet sheet, Map<String, Object> map) throws Exception {
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            int i = row.getFirstCellNum();
            while (i < row.getLastCellNum()) {
                this.setValueForCellByMap(row.getCell(i), map);
                ++i;
            }
        }
    }

    private void setValueForCellByMap(Cell cell, Map<String, Object> map) throws Exception {
        String oldString;
        try {
            oldString = cell.getStringCellValue();
        }
        catch (Exception e) {
            return;
        }
        if (oldString != null && oldString.indexOf("{{") != -1) {
            while (oldString.indexOf("{{") != -1) {
                String params = oldString.substring(oldString.indexOf("{{") + 2, oldString.indexOf("}}"));
                oldString = oldString.replace("{{" + params + "}}", this.getParamsValue(params.trim(), map));
            }
            cell.setCellValue(oldString);
        }
    }

    private String getParamsValue(String params, Map<String, Object> map) throws Exception {
        if (params.indexOf(".") != -1) {
            String[] paramsArr = params.split("\\.");
            return this.getValueDoWhile(map.get(paramsArr[0]), paramsArr, 1);
        }
        return map.containsKey(params) ? map.get(params).toString() : "";
    }

    private String getValueDoWhile(Object object, String[] paramsArr, int index) throws Exception {
        if (object == null) {
            return "";
        }
        object = object instanceof Map ? ((Map)object).get(paramsArr[index]) : POIPublicUtil.getMethod(paramsArr[index], object.getClass()).invoke(object, new Object[0]);
        return index == paramsArr.length - 1 ? (object == null ? "" : object.toString()) : this.getValueDoWhile(object, paramsArr, ++index);
    }
}

