/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.imports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.annotation.ExcelVerify;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelCollectionParams;
import org.jeecgframework.poi.excel.entity.params.ExcelImportEntity;
import org.jeecgframework.poi.excel.entity.params.ExcelVerifyEntity;
import org.jeecgframework.poi.excel.entity.result.ExcelImportResult;
import org.jeecgframework.poi.excel.entity.result.ExcelVerifyHanlderResult;
import org.jeecgframework.poi.excel.imports.CellValueServer;
import org.jeecgframework.poi.excel.imports.verifys.VerifyHandlerServer;
import org.jeecgframework.poi.util.POIPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportServer {
    private static final Logger logger = LoggerFactory.getLogger(ExcelImportServer.class);
    private CellValueServer cellValueServer = new CellValueServer();
    private VerifyHandlerServer verifyHandlerServer = new VerifyHandlerServer();
    private boolean verfiyFail = false;

    public ExcelImportResult importExcelByIs(InputStream inputstream, Class<?> pojoClass, ImportParams params) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Excel import start ,class is {}", pojoClass);
        }
        ArrayList result = new ArrayList();
        HSSFWorkbook book = null;
        boolean isXSSFWorkbook = true;
        if (!inputstream.markSupported()) {
            inputstream = new PushbackInputStream(inputstream, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)inputstream)) {
            book = new HSSFWorkbook(inputstream);
            isXSSFWorkbook = false;
        } else if (POIXMLDocument.hasOOXMLHeader((InputStream)inputstream)) {
            book = new XSSFWorkbook(OPCPackage.open((InputStream)inputstream));
        }
        int i = 0;
        while (i < params.getSheetNum()) {
            Map<String, PictureData> pictures = isXSSFWorkbook ? POIPublicUtil.getSheetPictrues07((XSSFSheet)book.getSheetAt(i), (XSSFWorkbook)book) : POIPublicUtil.getSheetPictrues03((HSSFSheet)book.getSheetAt(i), book);
            result.addAll(this.importExcel(result, book.getSheetAt(i), pojoClass, params, pictures));
            ++i;
        }
        if (params.isNeedSave()) {
            this.saveThisExcel(params, pojoClass, isXSSFWorkbook, (Workbook)book);
        }
        return new ExcelImportResult(result, this.verfiyFail, (Workbook)book);
    }

    private void saveThisExcel(ImportParams params, Class<?> pojoClass, boolean isXSSFWorkbook, Workbook book) throws Exception {
        String path = POIPublicUtil.getWebRootPath(this.getSaveExcelUrl(params, pojoClass));
        File savefile = new File(path);
        if (!savefile.exists()) {
            savefile.mkdirs();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyMMddHHmmss");
        FileOutputStream fos = new FileOutputStream(String.valueOf(path) + "/" + format.format(new Date()) + "_" + Math.round(Math.random() * 100000.0) + (isXSSFWorkbook ? ".xlsx" : ".xls"));
        book.write((OutputStream)fos);
        fos.close();
    }

    private String getSaveExcelUrl(ImportParams params, Class<?> pojoClass) throws Exception {
        String url = "";
        if (params.getSaveUrl().equals("upload/excelUpload")) {
            url = pojoClass.getName().split("\\.")[pojoClass.getName().split("\\.").length - 1];
            return String.valueOf(params.getSaveUrl()) + "/" + url.substring(0, url.lastIndexOf("Entity"));
        }
        return params.getSaveUrl();
    }

    private <T> List<T> importExcel(Collection<T> result, Sheet sheet, Class<?> pojoClass, ImportParams params, Map<String, PictureData> pictures) throws Exception {
        ArrayList<Object> collection = new ArrayList<Object>();
        HashMap<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
        ArrayList<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
        Field[] fileds = POIPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.value();
        }
        this.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null);
        Iterator rows = sheet.rowIterator();
        int j = 0;
        while (j < params.getTitleRows()) {
            rows.next();
            ++j;
        }
        Row row = null;
        HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
        int j2 = 0;
        while (j2 < params.getHeadRows()) {
            row = (Row)rows.next();
            Iterator cellTitle = row.cellIterator();
            int i = row.getFirstCellNum();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (!StringUtils.isEmpty((String)value)) {
                    titlemap.put(i, value);
                }
                ++i;
            }
            ++j2;
        }
        Object object = null;
        while (rows.hasNext()) {
            row = (Row)rows.next();
            if ((row.getCell(params.getKeyIndex()) == null || StringUtils.isEmpty((String)this.getKeyValue(row.getCell(params.getKeyIndex())))) && object != null) {
                for (ExcelCollectionParams param : excelCollection) {
                    this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                }
                continue;
            }
            object = POIPublicUtil.createObject(pojoClass, targetId);
            int i = row.getFirstCellNum();
            short le = row.getLastCellNum();
            while (i < le) {
                Cell cell = row.getCell(i);
                String titleString = (String)titlemap.get(i);
                if (excelParams.containsKey(titleString)) {
                    if (((ExcelImportEntity)excelParams.get(titleString)).getType() == 2) {
                        String picId = String.valueOf(row.getRowNum()) + "_" + i;
                        this.saveImage(object, picId, excelParams, titleString, pictures, params);
                    } else {
                        this.saveFieldValue(params, object, cell, excelParams, titleString, row);
                    }
                }
                ++i;
            }
            for (ExcelCollectionParams param : excelCollection) {
                this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
            }
            collection.add(object);
        }
        return collection;
    }

    private void saveFieldValue(ImportParams params, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString, Row row) throws Exception {
        Object value = this.cellValueServer.getValue(params.getDataHanlder(), object, cell, excelParams, titleString);
        ExcelVerifyHanlderResult verifyResult = this.verifyHandlerServer.verifyData(object, value, titleString, excelParams.get(titleString).getVerify(), params.getVerifyHanlder());
        if (verifyResult.isSuccess()) {
            this.setValues(excelParams.get(titleString), object, value);
        } else {
            Cell errorCell = row.createCell((int)row.getLastCellNum());
            errorCell.setCellValue(verifyResult.getMsg());
            this.verfiyFail = true;
        }
    }

    private String getKeyValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellType()) {
            case 1: {
                obj = cell.getStringCellValue();
                break;
            }
            case 4: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case 0: {
                obj = cell.getNumericCellValue();
            }
        }
        return obj == null ? null : obj.toString();
    }

    private void saveImage(Object object, String picId, Map<String, ExcelImportEntity> excelParams, String titleString, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        if (pictures == null) {
            return;
        }
        PictureData image = pictures.get(picId);
        byte[] data = image.getData();
        String fileName = "pic" + Math.round(Math.random() * 1.0E11);
        fileName = String.valueOf(fileName) + "." + POIPublicUtil.getFileExtendName(data);
        if (excelParams.get(titleString).getSaveType() == 1) {
            String path = POIPublicUtil.getWebRootPath(this.getSaveUrl(excelParams.get(titleString), object));
            File savefile = new File(path);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            savefile = new File(String.valueOf(path) + "/" + fileName);
            FileOutputStream fos = new FileOutputStream(savefile);
            fos.write(data);
            fos.close();
            this.setValues(excelParams.get(titleString), object, String.valueOf(this.getSaveUrl(excelParams.get(titleString), object)) + "/" + fileName);
        } else {
            this.setValues(excelParams.get(titleString), object, data);
        }
    }

    private String getSaveUrl(ExcelImportEntity excelImportEntity, Object object) throws Exception {
        String url = "";
        if (excelImportEntity.getSaveUrl().equals("upload")) {
            if (excelImportEntity.getMethods() != null && excelImportEntity.getMethods().size() > 0) {
                object = this.getFieldBySomeMethod(excelImportEntity.getMethods(), object);
            }
            url = object.getClass().getName().split("\\.")[object.getClass().getName().split("\\.").length - 1];
            return String.valueOf(excelImportEntity.getSaveUrl()) + "/" + url.substring(0, url.lastIndexOf("Entity"));
        }
        return excelImportEntity.getSaveUrl();
    }

    private void addListContinue(Object object, ExcelCollectionParams param, Row row, Map<Integer, String> titlemap, String targetId, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        Collection collection = (Collection)POIPublicUtil.getMethod(param.getName(), object.getClass()).invoke(object, new Object[0]);
        Object entity = POIPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        int i = row.getFirstCellNum();
        while (i < row.getLastCellNum()) {
            Cell cell = row.getCell(i);
            String titleString = titlemap.get(i);
            if (param.getExcelParams().containsKey(titleString)) {
                if (param.getExcelParams().get(titleString).getType() == 2) {
                    String picId = String.valueOf(row.getRowNum()) + "_" + i;
                    this.saveImage(object, picId, param.getExcelParams(), titleString, pictures, params);
                } else {
                    this.saveFieldValue(params, entity, cell, param.getExcelParams(), titleString, row);
                }
                isUsed = true;
            }
            ++i;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private void setValues(ExcelImportEntity entity, Object object, Object value) throws Exception {
        if (entity.getMethods() != null) {
            this.setFieldBySomeMethod(entity.getMethods(), object, value);
        } else {
            entity.getMethod().invoke(object, value);
        }
    }

    private void setFieldBySomeMethod(List<Method> setMethods, Object object, Object value) throws Exception {
        Object t = this.getFieldBySomeMethod(setMethods, object);
        setMethods.get(setMethods.size() - 1).invoke(t, value);
    }

    private Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        int i = 0;
        while (i < list.size() - 1) {
            Method m = list.get(i);
            t = m.invoke(t, new Object[0]);
            ++i;
        }
        return t;
    }

    private void getAllExcelField(String targetId, Field[] fields, Map<String, ExcelImportEntity> excelParams, List<ExcelCollectionParams> excelCollection, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        ExcelImportEntity excelEntity = null;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!POIPublicUtil.isNotUserExcelUserThis(null, field, targetId)) {
                if (POIPublicUtil.isCollection(field.getType())) {
                    ExcelCollectionParams collection = new ExcelCollectionParams();
                    collection.setName(field.getName());
                    HashMap<String, ExcelImportEntity> temp = new HashMap<String, ExcelImportEntity>();
                    ParameterizedType pt = (ParameterizedType)field.getGenericType();
                    Class clz = (Class)pt.getActualTypeArguments()[0];
                    collection.setType(clz);
                    this.getExcelFieldList(targetId, POIPublicUtil.getClassFields(clz), clz, temp, null);
                    collection.setExcelParams(temp);
                    excelCollection.add(collection);
                } else if (POIPublicUtil.isJavaClass(field)) {
                    this.addEntityToMap(targetId, field, excelEntity, pojoClass, getMethods, excelParams);
                } else {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    if (getMethods != null) {
                        newMethods.addAll(getMethods);
                    }
                    newMethods.add(POIPublicUtil.getMethod(field.getName(), pojoClass));
                    this.getAllExcelField(targetId, POIPublicUtil.getClassFields(field.getType()), excelParams, excelCollection, field.getType(), newMethods);
                }
            }
            ++i;
        }
    }

    private void getExcelFieldList(String targetId, Field[] fields, Class<?> pojoClass, Map<String, ExcelImportEntity> temp, List<Method> getMethods) throws Exception {
        ExcelImportEntity excelEntity = null;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!POIPublicUtil.isNotUserExcelUserThis(null, field, targetId)) {
                if (POIPublicUtil.isJavaClass(field)) {
                    this.addEntityToMap(targetId, field, excelEntity, pojoClass, getMethods, temp);
                } else {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    if (getMethods != null) {
                        newMethods.addAll(getMethods);
                    }
                    newMethods.add(POIPublicUtil.getMethod(field.getName(), pojoClass, field.getType()));
                    this.getExcelFieldList(targetId, POIPublicUtil.getClassFields(field.getType()), field.getType(), temp, newMethods);
                }
            }
            ++i;
        }
    }

    private void addEntityToMap(String targetId, Field field, ExcelImportEntity excelEntity, Class<?> pojoClass, List<Method> getMethods, Map<String, ExcelImportEntity> temp) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        excelEntity = new ExcelImportEntity();
        excelEntity.setType(excel.type());
        excelEntity.setSaveUrl(excel.savePath());
        excelEntity.setSaveType(excel.imageType());
        excelEntity.setReplace(excel.replace());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setVerify(this.getImportVerify(field));
        this.getExcelField(targetId, field, excelEntity, excel, pojoClass);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        temp.put(excelEntity.getName(), excelEntity);
    }

    private ExcelVerifyEntity getImportVerify(Field field) {
        ExcelVerify verify = field.getAnnotation(ExcelVerify.class);
        if (verify != null) {
            ExcelVerifyEntity entity = new ExcelVerifyEntity();
            entity.setEmail(verify.isEmail());
            entity.setInterHandler(verify.interHandler());
            entity.setMaxLength(verify.maxLength());
            entity.setMinLength(verify.minLength());
            entity.setMobile(verify.isMobile());
            entity.setNotNull(verify.notNull());
            entity.setRegex(verify.regex());
            entity.setRegexTip(verify.regexTip());
            entity.setTel(verify.isTel());
            return entity;
        }
        return null;
    }

    private void getExcelField(String targetId, Field field, ExcelImportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(this.getExcelName(excel.name(), targetId));
        String fieldname = field.getName();
        excelEntity.setMethod(POIPublicUtil.getMethod(fieldname, pojoClass, field.getType()));
        if (StringUtils.isEmpty((String)excel.importFormat())) {
            excelEntity.setFormat(excel.format());
        } else {
            excelEntity.setFormat(excel.importFormat());
        }
    }

    private String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf("_") < 0) {
            return exportName;
        }
        String[] stringArray = arr = exportName.split(",");
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.indexOf(targetId) != -1) {
                return str.split("_")[0];
            }
            ++n2;
        }
        return null;
    }
}

