/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.word.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.jeecgframework.poi.cache.WordCache;
import org.jeecgframework.poi.word.entity.JeecgXWPFDocument;
import org.jeecgframework.poi.word.entity.WordImageEntity;
import org.jeecgframework.poi.word.entity.params.ExcelListEntity;
import org.jeecgframework.poi.word.parse.excel.ExcelEntityParse;
import org.jeecgframework.poi.word.parse.excel.ExcelMapParse;
import org.jeecgframework.poi.word.util.ParseWordUtil;

public class ParseWord07 {
    public XWPFDocument parseWord(String url, Map<String, Object> map) throws Exception {
        JeecgXWPFDocument doc = WordCache.getXWPFDocumen(url);
        this.parseWordSetValue(doc, map);
        return doc;
    }

    public void parseWord(XWPFDocument document, Map<String, Object> map) throws Exception {
        this.parseWordSetValue((JeecgXWPFDocument)document, map);
    }

    private void parseWordSetValue(JeecgXWPFDocument doc, Map<String, Object> map) throws Exception {
        this.parseAllParagraphic(doc.getParagraphs(), map);
        Iterator itTable = doc.getTablesIterator();
        while (itTable.hasNext()) {
            XWPFTable table = (XWPFTable)itTable.next();
            if (table.getText().indexOf("{{") == -1) continue;
            this.parseThisTable(table, map);
        }
    }

    private void parseAllParagraphic(List<XWPFParagraph> paragraphs, Map<String, Object> map) throws Exception {
        int i = 0;
        while (i < paragraphs.size()) {
            XWPFParagraph paragraph = paragraphs.get(i);
            if (paragraph.getText().indexOf("{{") != -1) {
                this.parseThisParagraph(paragraph, map);
            }
            ++i;
        }
    }

    private void parseThisTable(XWPFTable table, Map<String, Object> map) throws Exception {
        ExcelEntityParse excelEntityParse = new ExcelEntityParse();
        int i = 0;
        while (i < table.getNumberOfRows()) {
            XWPFTableRow row = table.getRow(i);
            List cells = row.getTableCells();
            if (cells.size() == 1) {
                Object listobj = this.checkThisTableIsNeedIterator((XWPFTableCell)cells.get(0), map);
                if (listobj == null) {
                    this.parseThisRow(cells, map);
                } else if (listobj instanceof ExcelListEntity) {
                    table.removeRow(i);
                    excelEntityParse.parseNextRowAndAddRow(table, i, (ExcelListEntity)listobj);
                } else {
                    table.removeRow(i);
                    ExcelMapParse.parseNextRowAndAddRow(table, i, (List)listobj);
                }
            } else {
                this.parseThisRow(cells, map);
            }
            ++i;
        }
    }

    private void parseThisRow(List<XWPFTableCell> cells, Map<String, Object> map) throws Exception {
        for (XWPFTableCell cell : cells) {
            this.parseAllParagraphic(cell.getParagraphs(), map);
        }
    }

    private Object checkThisTableIsNeedIterator(XWPFTableCell cell, Map<String, Object> map) throws Exception {
        String text = cell.getText().trim();
        if (text.startsWith("{{") && text.endsWith("}}") && text.indexOf("in ") != -1) {
            return ParseWordUtil.getRealValue(text.replace("in ", "").trim(), map);
        }
        return null;
    }

    private void parseThisParagraph(XWPFParagraph paragraph, Map<String, Object> map) throws Exception {
        XWPFRun currentRun = null;
        String currentText = "";
        Boolean isfinde = false;
        ArrayList<Integer> runIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < paragraph.getRuns().size()) {
            XWPFRun run = (XWPFRun)paragraph.getRuns().get(i);
            String text = run.getText(0);
            if (text != null && text != "") {
                if (isfinde.booleanValue()) {
                    if ((currentText = String.valueOf(currentText) + text).indexOf("{{") == -1) {
                        isfinde = false;
                        runIndex.clear();
                    } else {
                        runIndex.add(i);
                    }
                    if (currentText.indexOf("}}") != -1) {
                        this.changeValues(paragraph, currentRun, currentText, runIndex, map);
                        currentText = "";
                        isfinde = false;
                    }
                } else if (text.indexOf("{") >= 0) {
                    currentText = text;
                    isfinde = true;
                    currentRun = run;
                } else {
                    currentText = "";
                }
                if (currentText.indexOf("}}") != -1) {
                    this.changeValues(paragraph, currentRun, currentText, runIndex, map);
                    isfinde = false;
                }
            }
            ++i;
        }
    }

    private void changeValues(XWPFParagraph paragraph, XWPFRun currentRun, String currentText, List<Integer> runIndex, Map<String, Object> map) throws Exception {
        Object obj = ParseWordUtil.getRealValue(currentText, map);
        if (obj instanceof WordImageEntity) {
            currentRun.setText("", 0);
            this.addAnImage((WordImageEntity)obj, currentRun);
        } else {
            currentText = obj.toString();
            currentRun.setText(currentText, 0);
        }
        int k = 0;
        while (k < runIndex.size()) {
            ((XWPFRun)paragraph.getRuns().get(runIndex.get(k))).setText("", 0);
            ++k;
        }
        runIndex.clear();
    }

    private void addAnImage(WordImageEntity obj, XWPFRun currentRun) throws Exception {
        Object[] isAndType = ParseWordUtil.getIsAndType(obj);
        try {
            String picId = currentRun.getParagraph().getDocument().addPictureData((byte[])isAndType[0], ((Integer)isAndType[1]).intValue());
            ((JeecgXWPFDocument)currentRun.getParagraph().getDocument()).createPicture(currentRun, picId, currentRun.getParagraph().getDocument().getNextPicNameNumber(((Integer)isAndType[1]).intValue()), obj.getWidth(), obj.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

