/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.word.parse.excel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.export.base.ExportBase;
import org.jeecgframework.poi.exception.word.WordExportException;
import org.jeecgframework.poi.exception.word.enmus.WordExportEnum;
import org.jeecgframework.poi.util.POIPublicUtil;
import org.jeecgframework.poi.word.entity.params.ExcelListEntity;

public class ExcelEntityParse
extends ExportBase {
    public void parseNextRowAndAddRow(XWPFTable table, int index, ExcelListEntity entity) {
        ExcelEntityParse.checkExcelParams(entity);
        Map<String, Integer> titlemap = this.getTitleMap(table, index, entity.getHeadRows());
        try {
            Field[] fileds = POIPublicUtil.getClassFields(entity.getClazz());
            ExcelTarget etarget = entity.getClazz().getAnnotation(ExcelTarget.class);
            String targetId = null;
            if (etarget != null) {
                targetId = etarget.value();
            }
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            this.getAllExcelField(null, targetId, fileds, excelParams, entity.getClazz(), null);
            this.sortAndFilterExportField(excelParams, titlemap);
            short rowHeight = this.getRowHeight(excelParams);
            for (Object t : entity.getList()) {
                index += this.createCells(index, t, excelParams, table, rowHeight);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int createCells(int index, Object t, List<ExcelExportEntity> excelParams, XWPFTable table, short rowHeight) throws Exception {
        ExcelExportEntity entity;
        XWPFTableRow row = table.createRow();
        row.setHeight((int)rowHeight);
        int maxHeight = 1;
        int cellNum = 0;
        int k = 0;
        int paramSize = excelParams.size();
        while (k < paramSize) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection list = (Collection)entity.getMethod().invoke(t, new Object[0]);
                int listC = 0;
                for (Object obj : list) {
                    this.createListCells(index + listC, cellNum, obj, entity.getList(), table);
                    ++listC;
                }
                cellNum += entity.getList().size();
                if (list != null && list.size() > maxHeight) {
                    maxHeight = list.size();
                }
            } else {
                Object value = this.getCellValue(entity, t);
                if (entity.getType() == 1) {
                    this.setCellValue(row, value, cellNum++);
                }
            }
            ++k;
        }
        cellNum = 0;
        k = 0;
        paramSize = excelParams.size();
        while (k < paramSize) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                cellNum += entity.getList().size();
            } else if (entity.isNeedMerge()) {
                table.setCellMargins(index, index + maxHeight - 1, cellNum, cellNum);
                ++cellNum;
            }
            ++k;
        }
        return maxHeight;
    }

    public void createListCells(int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, XWPFTable table) throws Exception {
        XWPFTableRow row;
        if (table.getRow(index) == null) {
            row = table.createRow();
            row.setHeight((int)this.getRowHeight(excelParams));
        } else {
            row = table.getRow(index);
        }
        int k = 0;
        int paramSize = excelParams.size();
        while (k < paramSize) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = this.getCellValue(entity, obj);
            if (entity.getType() == 1) {
                this.setCellValue(row, value, cellNum++);
            }
            ++k;
        }
    }

    private void setCellValue(XWPFTableRow row, Object value, int cellNum) {
        if (row.getCell(cellNum++) != null) {
            row.getCell(cellNum - 1).setText(value == null ? "" : value.toString());
        } else {
            row.createCell().setText(value == null ? "" : value.toString());
        }
    }

    private void sortAndFilterExportField(List<ExcelExportEntity> excelParams, Map<String, Integer> titlemap) {
        int i = excelParams.size() - 1;
        while (i >= 0) {
            if (excelParams.get(i).getList() != null && excelParams.get(i).getList().size() > 0) {
                this.sortAndFilterExportField(excelParams.get(i).getList(), titlemap);
                if (excelParams.get(i).getList().size() == 0) {
                    excelParams.remove(i);
                } else {
                    excelParams.get(i).setOrderNum(i);
                }
            } else if (titlemap.containsKey(excelParams.get(i).getName())) {
                excelParams.get(i).setOrderNum(i);
            } else {
                excelParams.remove(i);
            }
            --i;
        }
        this.sortAllParams(excelParams);
    }

    private Map<String, Integer> getTitleMap(XWPFTable table, int index, int headRows) {
        if (index < headRows) {
            throw new WordExportException(WordExportEnum.EXCEL_NO_HEAD);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int j = 0;
        while (j < headRows) {
            List cells = table.getRow(index - j - 1).getTableCells();
            int i = 0;
            while (i < cells.size()) {
                String text = ((XWPFTableCell)cells.get(i)).getText();
                if (StringUtils.isEmpty((String)text)) {
                    throw new WordExportException(WordExportEnum.EXCEL_HEAD_HAVA_NULL);
                }
                map.put(text, i);
                ++i;
            }
            ++j;
        }
        return map;
    }

    private static void checkExcelParams(ExcelListEntity entity) {
        if (entity.getList() == null || entity.getClazz() == null) {
            throw new WordExportException(WordExportEnum.EXCEL_PARAMS_ERROR);
        }
    }
}

