/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.word.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jeecgframework.poi.util.POIPublicUtil;
import org.jeecgframework.poi.word.entity.WordImageEntity;
import org.jeecgframework.poi.word.entity.params.ExcelListEntity;

public class ParseWordUtil {
    public static Object getRealValue(String currentText, Map<String, Object> map) throws Exception {
        String params = "";
        while (currentText.indexOf("{{") != -1) {
            params = currentText.substring(currentText.indexOf("{{") + 2, currentText.indexOf("}}"));
            Object obj = ParseWordUtil.getParamsValue(params.trim(), map);
            if (obj instanceof WordImageEntity || obj instanceof List || obj instanceof ExcelListEntity) {
                return obj;
            }
            currentText = currentText.replace("{{" + params + "}}", obj.toString());
        }
        return currentText;
    }

    private static Object getParamsValue(String params, Map<String, Object> map) throws Exception {
        if (params.indexOf(".") != -1) {
            String[] paramsArr = params.split("\\.");
            return ParseWordUtil.getValueDoWhile(map.get(paramsArr[0]), paramsArr, 1);
        }
        return map.containsKey(params) ? map.get(params) : "";
    }

    public static Object getValueDoWhile(Object object, String[] paramsArr, int index) throws Exception {
        if (object == null) {
            return "";
        }
        if (object instanceof WordImageEntity) {
            return object;
        }
        object = object instanceof Map ? ((Map)object).get(paramsArr[index]) : POIPublicUtil.getMethod(paramsArr[index], object.getClass()).invoke(object, new Object[0]);
        return index == paramsArr.length - 1 ? (object == null ? "" : object) : ParseWordUtil.getValueDoWhile(object, paramsArr, ++index);
    }

    public static Object[] getIsAndType(WordImageEntity entity) throws Exception {
        String type;
        Object[] result = new Object[2];
        if (entity.getType().equals(WordImageEntity.URL)) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            String path = String.valueOf(Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath()) + entity.getUrl();
            path = path.replace("WEB-INF/classes/", "");
            path = path.replace("file:/", "");
            BufferedImage bufferImg = ImageIO.read(new File(path));
            ImageIO.write((RenderedImage)bufferImg, entity.getUrl().substring(entity.getUrl().indexOf(".") + 1, entity.getUrl().length()), byteArrayOut);
            result[0] = byteArrayOut.toByteArray();
            type = entity.getUrl().split("/.")[entity.getUrl().split("/.").length - 1];
        } else {
            result[0] = entity.getData();
            type = POIPublicUtil.getFileExtendName(entity.getData());
        }
        result[1] = ParseWordUtil.getImageType(type);
        return result;
    }

    private static Integer getImageType(String type) {
        if (type.equalsIgnoreCase("JPG") || type.equalsIgnoreCase("JPEG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("GIF")) {
            return 8;
        }
        if (type.equalsIgnoreCase("BMP")) {
            return 8;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }
}

