/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.factory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class PackagesToScanUtil {
    private static final Logger logger = Logger.getLogger(PackagesToScanUtil.class);
    private static final String SUB_PACKAGE_SCREEN__SUFFIX = ".*";
    private static final String SUB_PACKAGE_SCREEN__SUFFIX_RE = ".\\*";

    public static Set<Class<?>> getClasses(String pack) {
        boolean recursive = false;
        String[] packArr = new String[]{};
        if (pack.lastIndexOf(SUB_PACKAGE_SCREEN__SUFFIX) != -1) {
            packArr = pack.split(SUB_PACKAGE_SCREEN__SUFFIX_RE);
            if (packArr.length > 1) {
                pack = packArr[0];
                int i = 0;
                while (i < packArr.length) {
                    packArr[i] = packArr[i].replace(SUB_PACKAGE_SCREEN__SUFFIX.substring(1), "");
                    ++i;
                }
            } else {
                pack = pack.replace(SUB_PACKAGE_SCREEN__SUFFIX, "");
            }
            recursive = true;
        }
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    logger.debug((Object)"-------------- file\u7c7b\u578b\u7684\u626b\u63cf ----------------");
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackagesToScanUtil.findAndAddClassesInPackageByFile(packageName, packArr, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                PackagesToScanUtil.findAndAddClassesInPackageByJarFile(packageName, packArr, url, packageDirName, recursive, classes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String[] packArr, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] fileArray = dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        int n = dirfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                PackagesToScanUtil.findAndAddClassesInPackageByFile(String.valueOf(packageName) + "." + file.getName(), packArr, file.getAbsolutePath(), recursive, classes);
            } else {
                String className = file.getName().substring(0, file.getName().length() - 6);
                try {
                    String classUrl = String.valueOf(packageName) + '.' + className;
                    if (classUrl.startsWith(".")) {
                        classUrl = classUrl.replaceFirst(".", "");
                    }
                    boolean flag = true;
                    if (packArr.length > 1) {
                        int i = 1;
                        while (i < packArr.length) {
                            if (classUrl.indexOf(packArr[i]) <= -1) {
                                flag = false;
                            }
                            ++i;
                        }
                    }
                    if (flag) {
                        classes.add(Thread.currentThread().getContextClassLoader().loadClass(classUrl));
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)"\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6");
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private static void findAndAddClassesInPackageByJarFile(String packageName, String[] packArr, URL url, String packageDirName, boolean recursive, Set<Class<?>> classes) {
        logger.debug((Object)"------------------------ jar\u7c7b\u578b\u7684\u626b\u63cf ----------------------");
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                try {
                    boolean flag = true;
                    if (packArr.length > 1) {
                        int i = 1;
                        while (i < packArr.length) {
                            if (packageName.indexOf(packArr[i]) <= -1) {
                                flag = false;
                            }
                            ++i;
                        }
                    }
                    if (!flag) continue;
                    classes.add(Class.forName(String.valueOf(packageName) + '.' + className));
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)"\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6");
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u5728\u626b\u63cf\u7528\u6237\u5b9a\u4e49\u89c6\u56fe\u65f6\u4ecejar\u5305\u83b7\u53d6\u6587\u4ef6\u51fa\u9519");
            e.printStackTrace();
        }
    }
}

