/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.spring.rowMapper;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.jeecgframework.minidao.util.BigDecimalConverter;
import org.jeecgframework.minidao.util.CamelCaseUtils;
import org.jeecgframework.minidao.util.DateConverter;
import org.jeecgframework.minidao.util.IntegerConverter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class GenericRowMapper<T>
implements RowMapper<T> {
    private Class<T> clazz;

    public GenericRowMapper(Class<T> claz) {
        this.clazz = claz;
    }

    public T mapRow(ResultSet resultset, int rowNum) throws SQLException {
        try {
            ResultSetMetaData rsmd = resultset.getMetaData();
            int columnCount = rsmd.getColumnCount();
            T bean = this.clazz.newInstance();
            ConvertUtils.register((Converter)new DateConverter(), Date.class);
            ConvertUtils.register((Converter)new BigDecimalConverter(), BigDecimal.class);
            ConvertUtils.register((Converter)new IntegerConverter(), Integer.class);
            int i = 1;
            while (i <= columnCount) {
                String key = this.getColumnKey(JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i));
                Object obj = this.getColumnValue(resultset, i);
                String camelKey = CamelCaseUtils.toCamelCase(key);
                BeanUtils.setProperty(bean, (String)camelKey, (Object)obj);
                ++i;
            }
            return bean;
        }
        catch (Exception e) {
            throw new SQLException("mapRow error.", e);
        }
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index);
    }
}

