/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.spring.rowMapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.jeecgframework.minidao.spring.map.MiniDaoLinkedMap;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class MiniColumnMapRowMapper
implements RowMapper<Map<String, Object>> {
    public Map<String, Object> mapRow(ResultSet resultset, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = resultset.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        int i = 1;
        while (i <= columnCount) {
            String key = this.getColumnKey(JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i));
            Object obj = this.getColumnValue(resultset, i);
            mapOfColValues.put(key, obj);
            ++i;
        }
        return mapOfColValues;
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return new MiniDaoLinkedMap(columnCount);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index);
    }
}

