/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.codegenerate.generate.onetomany;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.codegenerate.generate.CodeGenerate;
import org.jeecgframework.codegenerate.generate.ICallBack;
import org.jeecgframework.codegenerate.generate.onetomany.CodeFactoryOneToMany;
import org.jeecgframework.codegenerate.pojo.Columnt;
import org.jeecgframework.codegenerate.pojo.CreateFileProperty;
import org.jeecgframework.codegenerate.pojo.onetomany.CodeParamEntity;
import org.jeecgframework.codegenerate.pojo.onetomany.SubTableEntity;
import org.jeecgframework.codegenerate.util.CodeDateUtils;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.codegenerate.util.NonceUtils;
import org.jeecgframework.codegenerate.util.def.FtlDef;
import org.jeecgframework.codegenerate.util.def.JeecgKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerateOneToMany
implements ICallBack {
    private static final Log log = LogFactory.getLog(CodeGenerateOneToMany.class);
    private static String entityPackage = "test";
    private static String entityName = "Person";
    private static String tableName = "person";
    private static String ftlDescription = "\u7528\u6237";
    private static String primaryKeyPolicy = "uuid";
    private static String sequenceCode = "";
    private static String ftl_mode;
    public static String FTL_MODE_A;
    public static String FTL_MODE_B;
    private static List<SubTableEntity> subTabParam;
    private static CreateFileProperty createFileProperty;
    public static int FIELD_ROW_NUM;
    private List<Columnt> mainColums = new ArrayList<Columnt>();
    private List<Columnt> originalColumns = new ArrayList<Columnt>();
    private List<SubTableEntity> subTabFtl = new ArrayList<SubTableEntity>();
    private static JeecgReadTable dbFiledUtil;

    static {
        FTL_MODE_A = "A";
        FTL_MODE_B = "B";
        subTabParam = new ArrayList<SubTableEntity>();
        createFileProperty = new CreateFileProperty();
        FIELD_ROW_NUM = 4;
        dbFiledUtil = new JeecgReadTable();
        createFileProperty.setActionFlag(true);
        createFileProperty.setServiceIFlag(true);
        createFileProperty.setJspFlag(true);
        createFileProperty.setServiceImplFlag(true);
        createFileProperty.setPageFlag(true);
        createFileProperty.setEntityFlag(true);
    }

    public CodeGenerateOneToMany() {
    }

    public CodeGenerateOneToMany(String entityPackage, String entityName, String tableName, List<SubTableEntity> subTabParam, String ftlDescription, CreateFileProperty createFileProperty, String primaryKeyPolicy, String sequenceCode) {
        CodeGenerateOneToMany.entityName = entityName;
        CodeGenerateOneToMany.entityPackage = entityPackage;
        CodeGenerateOneToMany.tableName = tableName;
        CodeGenerateOneToMany.ftlDescription = ftlDescription;
        CodeGenerateOneToMany.createFileProperty = createFileProperty;
        CodeGenerateOneToMany.subTabParam = subTabParam;
        CodeGenerateOneToMany.primaryKeyPolicy = StringUtils.isNotBlank((String)primaryKeyPolicy) ? primaryKeyPolicy : "uuid";
        CodeGenerateOneToMany.sequenceCode = sequenceCode;
    }

    public CodeGenerateOneToMany(CodeParamEntity codeParamEntity) {
        entityName = codeParamEntity.getEntityName();
        entityPackage = codeParamEntity.getEntityPackage();
        tableName = codeParamEntity.getTableName();
        ftlDescription = codeParamEntity.getFtlDescription();
        subTabParam = codeParamEntity.getSubTabParam();
        ftl_mode = codeParamEntity.getFtl_mode();
        primaryKeyPolicy = StringUtils.isNotBlank((String)codeParamEntity.getPrimaryKeyPolicy()) ? codeParamEntity.getPrimaryKeyPolicy() : "uuid";
        sequenceCode = codeParamEntity.getSequenceCode();
    }

    @Override
    public Map<String, Object> execute() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("bussiPackage", CodeResourceUtil.bussiPackage);
        data.put("entityPackage", entityPackage);
        data.put("entityName", entityName);
        data.put("tableName", tableName);
        data.put("ftl_description", ftlDescription);
        data.put("jeecg_table_id", CodeResourceUtil.JEECG_GENERATE_TABLE_ID);
        data.put(FtlDef.JEECG_PRIMARY_KEY_POLICY, primaryKeyPolicy);
        data.put(FtlDef.JEECG_SEQUENCE_CODE, sequenceCode);
        data.put("ftl_create_time", CodeDateUtils.dateToString(new Date()));
        data.put(FtlDef.FIELD_REQUIRED_NAME, StringUtils.isNotEmpty((String)CodeResourceUtil.JEECG_UI_FIELD_REQUIRED_NUM) ? Integer.parseInt(CodeResourceUtil.JEECG_UI_FIELD_REQUIRED_NUM) : -1);
        data.put(FtlDef.SEARCH_FIELD_NUM, StringUtils.isNotEmpty((String)CodeResourceUtil.JEECG_UI_FIELD_SEARCH_NUM) ? Integer.parseInt(CodeResourceUtil.JEECG_UI_FIELD_SEARCH_NUM) : -1);
        data.put(FtlDef.FIELD_ROW_NAME, FIELD_ROW_NUM);
        try {
            this.mainColums = dbFiledUtil.readTableColumn(tableName);
            data.put("mainColums", this.mainColums);
            data.put("columns", this.mainColums);
            this.originalColumns = dbFiledUtil.readOriginalTableColumn(tableName);
            data.put("originalColumns", this.originalColumns);
            for (Columnt c : this.originalColumns) {
                if (!c.getFieldName().toLowerCase().equals(CodeResourceUtil.JEECG_GENERATE_TABLE_ID.toLowerCase())) continue;
                data.put("primary_key_type", c.getFieldType());
            }
            this.subTabFtl.clear();
            for (SubTableEntity subTableEntity : subTabParam) {
                SubTableEntity po = new SubTableEntity();
                List<Columnt> subColum = dbFiledUtil.readTableColumn(subTableEntity.getTableName());
                po.setSubColums(subColum);
                po.setEntityName(subTableEntity.getEntityName());
                po.setFtlDescription(subTableEntity.getFtlDescription());
                po.setTableName(subTableEntity.getTableName());
                po.setEntityPackage(subTableEntity.getEntityPackage());
                String[] fkeys = subTableEntity.getForeignKeys();
                ArrayList<String> foreignKeys = new ArrayList<String>();
                String[] stringArray = fkeys;
                int n = fkeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (CodeResourceUtil.JEECG_FILED_CONVERT) {
                        foreignKeys.add(JeecgReadTable.formatFieldCapital(key));
                    } else {
                        String keyStr = key.toLowerCase();
                        String field = String.valueOf(keyStr.substring(0, 1).toUpperCase()) + keyStr.substring(1);
                        foreignKeys.add(field);
                    }
                    ++n2;
                }
                po.setForeignKeys(foreignKeys.toArray(new String[0]));
                this.subTabFtl.add(po);
            }
            data.put("subTab", this.subTabFtl);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        long serialVersionUID = NonceUtils.randomLong() + NonceUtils.currentMills();
        data.put("serialVersionUID", String.valueOf(serialVersionUID));
        return data;
    }

    public void generateToFile() {
        CodeFactoryOneToMany codeFactoryOneToMany = new CodeFactoryOneToMany();
        codeFactoryOneToMany.setCallBack(new CodeGenerateOneToMany());
        if (createFileProperty.isJspFlag()) {
            codeFactoryOneToMany.invoke("onetomany/jspListTemplate.ftl", "jspList");
            codeFactoryOneToMany.invoke("onetomany/jspTemplate.ftl", "jsp");
        }
        if (createFileProperty.isServiceImplFlag()) {
            codeFactoryOneToMany.invoke("onetomany/serviceImplTemplate.ftl", "serviceImpl");
        }
        if (createFileProperty.isServiceIFlag()) {
            codeFactoryOneToMany.invoke("onetomany/serviceITemplate.ftl", "service");
        }
        if (createFileProperty.isActionFlag()) {
            codeFactoryOneToMany.invoke("onetomany/controllerTemplate.ftl", "controller");
        }
        if (createFileProperty.isEntityFlag()) {
            codeFactoryOneToMany.invoke("onetomany/entityTemplate.ftl", "entity");
        }
        if (createFileProperty.isPageFlag()) {
            codeFactoryOneToMany.invoke("onetomany/pageTemplate.ftl", "page");
        }
    }

    public static void main(String[] args) {
        ArrayList<SubTableEntity> subTabParamIn = new ArrayList<SubTableEntity>();
        SubTableEntity po = new SubTableEntity();
        po.setTableName("jeecg_order_custom");
        po.setEntityName("OrderCustom");
        po.setEntityPackage("order");
        po.setFtlDescription("\u8ba2\u5355\u5ba2\u6237\u660e\u7ec6");
        po.setPrimaryKeyPolicy(JeecgKey.UUID);
        po.setSequenceCode(null);
        po.setForeignKeys(new String[]{"GORDER_OBID", "GO_ORDER_CODE"});
        subTabParamIn.add(po);
        SubTableEntity po2 = new SubTableEntity();
        po2.setTableName("jeecg_order_product");
        po2.setEntityName("OrderProduct");
        po2.setEntityPackage("order");
        po2.setFtlDescription("\u8ba2\u5355\u4ea7\u54c1\u660e\u7ec6");
        po2.setForeignKeys(new String[]{"GORDER_OBID", "GO_ORDER_CODE"});
        po2.setPrimaryKeyPolicy(JeecgKey.UUID);
        po2.setSequenceCode(null);
        subTabParamIn.add(po2);
        CodeParamEntity codeParamEntityIn = new CodeParamEntity();
        codeParamEntityIn.setTableName("jeecg_order_main");
        codeParamEntityIn.setEntityName("OrderMain");
        codeParamEntityIn.setEntityPackage("order");
        codeParamEntityIn.setFtlDescription("\u8ba2\u5355\u62ac\u5934");
        codeParamEntityIn.setFtl_mode(FTL_MODE_B);
        codeParamEntityIn.setPrimaryKeyPolicy(JeecgKey.UUID);
        codeParamEntityIn.setSequenceCode(null);
        codeParamEntityIn.setSubTabParam(subTabParamIn);
        CodeGenerateOneToMany.oneToManyCreate(subTabParamIn, codeParamEntityIn);
    }

    public static void oneToManyCreate(List<SubTableEntity> subTabParamIn, CodeParamEntity codeParamEntityIn) {
        log.info((Object)("----jeecg----Code-----Generation-----[\u4e00\u5bf9\u591a\u6570\u636e\u6a21\u578b\uff1a" + codeParamEntityIn.getTableName() + "]------- \u751f\u6210\u4e2d\u3002\u3002\u3002"));
        CreateFileProperty subFileProperty = new CreateFileProperty();
        subFileProperty.setActionFlag(false);
        subFileProperty.setServiceIFlag(false);
        subFileProperty.setJspFlag(true);
        subFileProperty.setServiceImplFlag(false);
        subFileProperty.setPageFlag(false);
        subFileProperty.setEntityFlag(true);
        subFileProperty.setJspMode("03");
        for (SubTableEntity sub : subTabParamIn) {
            String[] fkeys = sub.getForeignKeys();
            ArrayList<String> foreignKeys = new ArrayList<String>();
            String[] stringArray = fkeys;
            int n = fkeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (CodeResourceUtil.JEECG_FILED_CONVERT) {
                    foreignKeys.add(JeecgReadTable.formatFieldCapital(key));
                } else {
                    String keyStr = key.toLowerCase();
                    String field = String.valueOf(keyStr.substring(0, 1).toUpperCase()) + keyStr.substring(1);
                    foreignKeys.add(field);
                }
                ++n2;
            }
            new CodeGenerate(sub.getEntityPackage(), sub.getEntityName(), sub.getTableName(), sub.getFtlDescription(), subFileProperty, StringUtils.isNotBlank((String)sub.getPrimaryKeyPolicy()) ? sub.getPrimaryKeyPolicy() : "uuid", sub.getSequenceCode(), foreignKeys.toArray(new String[0])).generateToFile();
        }
        new CodeGenerateOneToMany(codeParamEntityIn).generateToFile();
        log.info((Object)("----jeecg----Code----Generation------[\u4e00\u5bf9\u591a\u6570\u636e\u6a21\u578b\uff1a" + codeParamEntityIn.getTableName() + "]------ \u751f\u6210\u5b8c\u6210\u3002\u3002\u3002"));
    }
}

