/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.codegenerate.generate.onetomany;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.codegenerate.generate.CgformCodeGenerate;
import org.jeecgframework.codegenerate.generate.ICallBack;
import org.jeecgframework.codegenerate.generate.onetomany.CgformCodeFactoryOneToMany;
import org.jeecgframework.codegenerate.pojo.CreateFileProperty;
import org.jeecgframework.codegenerate.pojo.onetomany.CodeParamEntity;
import org.jeecgframework.codegenerate.pojo.onetomany.SubTableEntity;
import org.jeecgframework.codegenerate.util.CodeDateUtils;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.codegenerate.util.NonceUtils;
import org.jeecgframework.codegenerate.util.def.FtlDef;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.generate.GenerateEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CgformCodeGenerateOneToMany
implements ICallBack {
    private static final Log log = LogFactory.getLog(CgformCodeGenerateOneToMany.class);
    private String entityPackage = "test";
    private String entityName = "Person";
    private String tableName = "person";
    private String ftlDescription = "\u7528\u6237";
    private String primaryKeyPolicy = "uuid";
    private String sequenceCode = "";
    private static String ftl_mode;
    public static String FTL_MODE_A;
    public static String FTL_MODE_B;
    private static List<SubTableEntity> subTabParam;
    private static CreateFileProperty createFileProperty;
    public static int FIELD_ROW_NUM;
    private List<SubTableEntity> subTabFtl = new ArrayList<SubTableEntity>();
    private CodeParamEntity codeParamEntityIn;
    private GenerateEntity mainG;
    private Map<String, GenerateEntity> subsG;
    private List<SubTableEntity> subTabParamIn;

    static {
        FTL_MODE_A = "A";
        FTL_MODE_B = "B";
        subTabParam = new ArrayList<SubTableEntity>();
        createFileProperty = new CreateFileProperty();
        FIELD_ROW_NUM = 4;
        createFileProperty.setActionFlag(true);
        createFileProperty.setServiceIFlag(true);
        createFileProperty.setJspFlag(true);
        createFileProperty.setServiceImplFlag(true);
        createFileProperty.setPageFlag(true);
        createFileProperty.setEntityFlag(true);
    }

    public CgformCodeGenerateOneToMany() {
    }

    public CgformCodeGenerateOneToMany(List<SubTableEntity> subTabParamIn, CodeParamEntity codeParamEntityIn, GenerateEntity mainG, Map<String, GenerateEntity> subsG) {
        this.entityName = codeParamEntityIn.getEntityName();
        this.entityPackage = codeParamEntityIn.getEntityPackage();
        this.tableName = codeParamEntityIn.getTableName();
        this.ftlDescription = codeParamEntityIn.getFtlDescription();
        subTabParam = codeParamEntityIn.getSubTabParam();
        ftl_mode = codeParamEntityIn.getFtl_mode();
        this.primaryKeyPolicy = "uuid";
        this.sequenceCode = codeParamEntityIn.getSequenceCode();
        this.subTabParamIn = subTabParamIn;
        this.mainG = mainG;
        this.subsG = subsG;
        this.codeParamEntityIn = codeParamEntityIn;
    }

    @Override
    public Map<String, Object> execute() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("bussiPackage", CodeResourceUtil.bussiPackage);
        data.put("entityPackage", this.entityPackage);
        data.put("entityName", this.entityName);
        data.put("tableName", this.tableName);
        data.put("ftl_description", this.ftlDescription);
        data.put("jeecg_table_id", CodeResourceUtil.JEECG_GENERATE_TABLE_ID);
        data.put(FtlDef.JEECG_PRIMARY_KEY_POLICY, this.primaryKeyPolicy);
        data.put(FtlDef.JEECG_SEQUENCE_CODE, this.sequenceCode);
        data.put("ftl_create_time", CodeDateUtils.dateToString(new Date()));
        data.put(FtlDef.FIELD_REQUIRED_NAME, StringUtils.isNotEmpty((String)CodeResourceUtil.JEECG_UI_FIELD_REQUIRED_NUM) ? Integer.parseInt(CodeResourceUtil.JEECG_UI_FIELD_REQUIRED_NUM) : -1);
        data.put(FtlDef.SEARCH_FIELD_NUM, StringUtils.isNotEmpty((String)CodeResourceUtil.JEECG_UI_FIELD_SEARCH_NUM) ? Integer.parseInt(CodeResourceUtil.JEECG_UI_FIELD_SEARCH_NUM) : -1);
        data.put(FtlDef.FIELD_ROW_NAME, FIELD_ROW_NUM);
        try {
            HashMap<String, String> fieldMeta = new HashMap<String, String>();
            List columns = this.mainG.deepCopy().getCgFormHead().getColumns();
            for (CgFormFieldEntity cf : columns) {
                String type = cf.getType();
                if ("string".equalsIgnoreCase(type)) {
                    cf.setType("java.lang.String");
                } else if ("Date".equalsIgnoreCase(type)) {
                    cf.setType("java.util.Date");
                } else if ("double".equalsIgnoreCase(type)) {
                    cf.setType("java.lang.Double");
                } else if ("int".equalsIgnoreCase(type)) {
                    cf.setType("java.lang.Integer");
                } else if ("BigDecimal".equalsIgnoreCase(type)) {
                    cf.setType("java.math.BigDecimal");
                } else if ("Text".equalsIgnoreCase(type)) {
                    cf.setType("javax.xml.soap.Text");
                } else if ("Blob".equalsIgnoreCase(type)) {
                    cf.setType("java.sql.Blob");
                }
                String fieldName = cf.getFieldName();
                String fieldNameV = JeecgReadTable.formatField(fieldName);
                cf.setFieldName(fieldNameV);
                fieldMeta.put(fieldNameV, fieldName.toUpperCase());
            }
            ArrayList<CgFormFieldEntity> pageColumns = new ArrayList<CgFormFieldEntity>();
            for (CgFormFieldEntity cf : columns) {
                if (!StringUtils.isNotEmpty((String)cf.getIsShow()) || !"Y".equalsIgnoreCase(cf.getIsShow())) continue;
                pageColumns.add(cf);
            }
            String[] subtables = this.mainG.getCgFormHead().getSubTableStr().split(",");
            data.put("cgformConfig", this.mainG);
            data.put("fieldMeta", fieldMeta);
            data.put("columns", columns);
            data.put("pageColumns", pageColumns);
            data.put("buttons", this.mainG.getButtons() == null ? new ArrayList(0) : this.mainG.getButtons());
            data.put("buttonSqlMap", this.mainG.getButtonSqlMap() == null ? new HashMap(0) : this.mainG.getButtonSqlMap());
            data.put("subtables", subtables);
            data.put("subTab", this.subTabParamIn);
            HashMap<String, List> subColumnsMap = new HashMap<String, List>(0);
            HashMap subPageColumnsMap = new HashMap(0);
            HashMap<String, String> subFieldMeta = new HashMap<String, String>(0);
            HashMap<String, String> subFieldMeta1 = new HashMap<String, String>(0);
            for (String key : this.subsG.keySet()) {
                GenerateEntity subG = this.subsG.get(key);
                List subColumns = subG.deepCopy().getCgFormHead().getColumns();
                ArrayList<CgFormFieldEntity> subPageColumns = new ArrayList<CgFormFieldEntity>();
                for (CgFormFieldEntity cf : subColumns) {
                    String type = cf.getType();
                    if ("string".equalsIgnoreCase(type)) {
                        cf.setType("java.lang.String");
                    } else if ("Date".equalsIgnoreCase(type)) {
                        cf.setType("java.util.Date");
                    } else if ("double".equalsIgnoreCase(type)) {
                        cf.setType("java.lang.Double");
                    } else if ("int".equalsIgnoreCase(type)) {
                        cf.setType("java.lang.Integer");
                    } else if ("BigDecimal".equalsIgnoreCase(type)) {
                        cf.setType("java.math.BigDecimal");
                    } else if ("Text".equalsIgnoreCase(type)) {
                        cf.setType("javax.xml.soap.Text");
                    } else if ("Blob".equalsIgnoreCase(type)) {
                        cf.setType("java.sql.Blob");
                    }
                    String fieldName = cf.getFieldName();
                    String fieldNameV = JeecgReadTable.formatField(fieldName);
                    cf.setFieldName(fieldNameV);
                    subFieldMeta.put(fieldNameV, fieldName.toUpperCase());
                    subFieldMeta1.put(fieldName.toUpperCase(), fieldNameV);
                    if (StringUtils.isNotEmpty((String)cf.getIsShow()) && "Y".equalsIgnoreCase(cf.getIsShow())) {
                        subPageColumns.add(cf);
                    }
                    String mtable = cf.getMainTable();
                    String mfiled = cf.getMainField();
                    if (mtable != null && mtable.equalsIgnoreCase(this.mainG.getTableName())) {
                        data.put(String.valueOf(key) + "_fk", mfiled);
                    }
                    subColumnsMap.put(key, subColumns);
                    subPageColumnsMap.put(key, subPageColumns);
                }
                data.put("subColumnsMap", subColumnsMap);
                data.put("subPageColumnsMap", subPageColumnsMap);
                data.put("subFieldMeta", subFieldMeta);
                data.put("subFieldMeta1", subFieldMeta1);
                data.put("packageStyle", this.mainG.getPackageStyle());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long serialVersionUID = NonceUtils.randomLong() + NonceUtils.currentMills();
        data.put("serialVersionUID", String.valueOf(serialVersionUID));
        return data;
    }

    public void generateToFile() throws TemplateException, IOException {
        CgformCodeFactoryOneToMany codeFactoryOneToMany = new CgformCodeFactoryOneToMany();
        codeFactoryOneToMany.setProjectPath(this.mainG.getProjectPath());
        codeFactoryOneToMany.setPackageStyle(this.mainG.getPackageStyle());
        codeFactoryOneToMany.setCallBack(new CgformCodeGenerateOneToMany(this.subTabParamIn, this.codeParamEntityIn, this.mainG, this.subsG));
        if (createFileProperty.isJspFlag()) {
            codeFactoryOneToMany.invoke("onetomany/cgform_jspListTemplate.ftl", "jspList");
            codeFactoryOneToMany.invoke("onetomany/cgform_jspTemplate_add.ftl", "jsp_add");
            codeFactoryOneToMany.invoke("onetomany/cgform_jspTemplate_update.ftl", "jsp_update");
            codeFactoryOneToMany.invoke("onetomany/cgform_jsEnhanceTemplate.ftl", "js");
            codeFactoryOneToMany.invoke("onetomany/cgform_jsListEnhanceTemplate.ftl", "jsList");
        }
        if (createFileProperty.isServiceImplFlag()) {
            codeFactoryOneToMany.invoke("onetomany/cgform_serviceImplTemplate.ftl", "serviceImpl");
        }
        if (createFileProperty.isServiceIFlag()) {
            codeFactoryOneToMany.invoke("onetomany/cgform_serviceITemplate.ftl", "service");
        }
        if (createFileProperty.isActionFlag()) {
            codeFactoryOneToMany.invoke("onetomany/cgform_controllerTemplate.ftl", "controller");
        }
        if (createFileProperty.isEntityFlag()) {
            codeFactoryOneToMany.invoke("onetomany/cgform_entityTemplate.ftl", "entity");
        }
        if (createFileProperty.isPageFlag()) {
            codeFactoryOneToMany.invoke("onetomany/cgform_pageTemplate.ftl", "page");
        }
    }

    public static void oneToManyCreate(List<SubTableEntity> subTabParamIn, CodeParamEntity codeParamEntityIn, GenerateEntity mainG, Map<String, GenerateEntity> subsG) throws TemplateException, IOException {
        log.info((Object)("----jeecg----Code-----Generation-----[\u4e00\u5bf9\u591a\u6570\u636e\u6a21\u578b\uff1a" + codeParamEntityIn.getTableName() + "]------- \u751f\u6210\u4e2d\u3002\u3002\u3002"));
        CreateFileProperty subFileProperty = new CreateFileProperty();
        subFileProperty.setActionFlag(false);
        subFileProperty.setServiceIFlag(false);
        subFileProperty.setJspFlag(true);
        subFileProperty.setServiceImplFlag(false);
        subFileProperty.setPageFlag(false);
        subFileProperty.setEntityFlag(true);
        subFileProperty.setJspMode("03");
        for (SubTableEntity sub : subTabParamIn) {
            String[] foreignKeys = sub.getForeignKeys();
            GenerateEntity subG = subsG.get(sub.getTableName());
            new CgformCodeGenerate(sub, subG, subFileProperty, "uuid", foreignKeys).generateToFile();
        }
        new CgformCodeGenerateOneToMany(subTabParamIn, codeParamEntityIn, mainG, subsG).generateToFile();
        log.info((Object)("----jeecg----Code----Generation------[\u4e00\u5bf9\u591a\u6570\u636e\u6a21\u578b\uff1a" + codeParamEntityIn.getTableName() + "]------ \u751f\u6210\u5b8c\u6210\u3002\u3002\u3002"));
    }
}

