/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.postgresql.PGBlobOutputStream;

public class PGBlob
implements Blob {
    private byte[] buf = new byte[0];
    private int len = 0;

    @Override
    public long length() throws SQLException {
        return this.len;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.isValid();
        if (length == 0) {
            return new byte[0];
        }
        if (length > this.len) {
            length = this.len;
        }
        if (pos < 1L || (long)this.len - pos < 0L) {
            throw new SQLException("Invalid arguments: position cannot be less than 1 or greater than the length of the SerialBlob");
        }
        --pos;
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = this.buf[(int)pos];
            ++pos;
        }
        return b;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.buf);
        return stream;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.isValid();
        if (start < 1L || start > (long)this.len) {
            return -1L;
        }
        int pos = (int)start - 1;
        long patlen = pattern.length;
        while (pos < this.len) {
            if (pattern[0] == this.buf[pos]) {
                boolean flag = true;
                int j = 0;
                while ((long)j < patlen) {
                    if (pattern[j] != this.buf[pos + j]) {
                        flag = false;
                    }
                    ++j;
                }
                if (flag) {
                    return pos + 1;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.isValid();
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int length) throws SQLException {
        int i;
        if (offset < 0 || offset > bytes.length) {
            throw new SQLException("Invalid offset in byte array set");
        }
        if (pos < 1L || pos > this.length() + 1L) {
            throw new SQLException("Invalid position in BLOB object set");
        }
        if (length + offset > bytes.length) {
            throw new SQLException("Invalid OffSet. Cannot have combined offset and length that is greater that the Blob buffer");
        }
        int j = Math.min(length, bytes.length - offset);
        byte[] tmp = new byte[(int)(pos - 1L + (long)j)];
        if (this.len > 0) {
            System.arraycopy(this.buf, 0, tmp, 0, this.len);
        }
        --pos;
        for (i = 0; i < length && i < bytes.length - offset; ++i) {
            tmp[(int)pos + i] = bytes[offset + i];
        }
        this.buf = tmp;
        this.len = this.buf.length;
        return i;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return new PGBlobOutputStream(this, 32768, pos);
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.isValid();
        if (length > (long)this.len) {
            throw new SQLException("Length more than what can be truncated");
        }
        if ((int)length == 0) {
            this.buf = new byte[0];
            this.len = (int)length;
        } else {
            this.len = (int)length;
            this.buf = this.getBytes(1L, this.len);
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.isValid();
        if (pos < 1L || pos > this.length()) {
            throw new SQLException("Invalid position in BLOB object set");
        }
        if (length < 1L || length > (long)this.len - pos + 1L) {
            throw new SQLException("length is < 1 or pos + length > total number of bytes");
        }
        return new ByteArrayInputStream(this.buf, (int)pos - 1, (int)length);
    }

    private void isValid() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("Error: You cannot call a method on a SerialBlob instance once free() has been called.");
        }
    }
}

