/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.model;

import org.springframework.boot.autoconfigure.klock.handler.KlockTimeoutException;
import org.springframework.boot.autoconfigure.klock.handler.release.ReleaseTimeoutHandler;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;

public enum ReleaseTimeoutStrategy implements ReleaseTimeoutHandler
{
    NO_OPERATION{

        @Override
        public void handle(LockInfo lockInfo) {
        }
    }
    ,
    FAIL_FAST{

        @Override
        public void handle(LockInfo lockInfo) {
            String errorMsg = String.format("Found Lock(%s) already been released while lock lease time is %d s", lockInfo.getName(), lockInfo.getLeaseTime());
            throw new KlockTimeoutException(errorMsg);
        }
    };

}

