/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.boot.autoconfigure.klock.core.LockInfoProvider;
import org.springframework.boot.autoconfigure.klock.handler.KlockInvocationException;
import org.springframework.boot.autoconfigure.klock.lock.Lock;
import org.springframework.boot.autoconfigure.klock.lock.LockFactory;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
@Order(value=0)
public class KlockAspectHandler {
    private static final Logger logger = LoggerFactory.getLogger(KlockAspectHandler.class);
    @Autowired
    LockFactory lockFactory;
    @Autowired
    private LockInfoProvider lockInfoProvider;
    private ThreadLocal<LockRes> currentThreadLock = new ThreadLocal();

    @Around(value="@annotation(klock)")
    public Object around(ProceedingJoinPoint joinPoint, Klock klock) throws Throwable {
        LockInfo lockInfo = this.lockInfoProvider.get(joinPoint, klock);
        this.currentThreadLock.set(new LockRes(lockInfo, false));
        Lock lock = this.lockFactory.getLock(lockInfo);
        boolean lockRes = lock.acquire();
        if (!lockRes) {
            if (logger.isWarnEnabled()) {
                logger.warn("Timeout while acquiring Lock({})", (Object)lockInfo.getName());
            }
            if (!StringUtils.isEmpty((Object)klock.customLockTimeoutStrategy())) {
                return this.handleCustomLockTimeout(klock.customLockTimeoutStrategy(), (JoinPoint)joinPoint);
            }
            klock.lockTimeoutStrategy().handle(lockInfo, lock, (JoinPoint)joinPoint);
        }
        this.currentThreadLock.get().setLock(lock);
        this.currentThreadLock.get().setRes(true);
        return joinPoint.proceed();
    }

    @AfterReturning(value="@annotation(klock)")
    public void afterReturning(JoinPoint joinPoint, Klock klock) throws Throwable {
        this.releaseLock(klock, joinPoint);
        this.cleanUpThreadLocal();
    }

    @AfterThrowing(value="@annotation(klock)", throwing="ex")
    public void afterThrowing(JoinPoint joinPoint, Klock klock, Throwable ex) throws Throwable {
        this.releaseLock(klock, joinPoint);
        this.cleanUpThreadLocal();
        throw ex;
    }

    private Object handleCustomLockTimeout(String lockTimeoutHandler, JoinPoint joinPoint) throws Throwable {
        Method currentMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object target = joinPoint.getTarget();
        Method handleMethod = null;
        try {
            handleMethod = joinPoint.getTarget().getClass().getDeclaredMethod(lockTimeoutHandler, currentMethod.getParameterTypes());
            handleMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Illegal annotation param customLockTimeoutStrategy", e);
        }
        Object[] args = joinPoint.getArgs();
        Object res = null;
        try {
            res = handleMethod.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new KlockInvocationException("Fail to invoke custom lock timeout handler: " + lockTimeoutHandler, e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return res;
    }

    private void releaseLock(Klock klock, JoinPoint joinPoint) throws Throwable {
        LockRes lockRes = this.currentThreadLock.get();
        if (lockRes.getRes().booleanValue()) {
            boolean releaseRes = this.currentThreadLock.get().getLock().release();
            lockRes.setRes(false);
            if (!releaseRes) {
                this.handleReleaseTimeout(klock, lockRes.getLockInfo(), joinPoint);
            }
        }
    }

    private void handleReleaseTimeout(Klock klock, LockInfo lockInfo, JoinPoint joinPoint) throws Throwable {
        if (logger.isWarnEnabled()) {
            logger.warn("Timeout while release Lock({})", (Object)lockInfo.getName());
        }
        if (!StringUtils.isEmpty((Object)klock.customReleaseTimeoutStrategy())) {
            this.handleCustomReleaseTimeout(klock.customReleaseTimeoutStrategy(), joinPoint);
        } else {
            klock.releaseTimeoutStrategy().handle(lockInfo);
        }
    }

    private void handleCustomReleaseTimeout(String releaseTimeoutHandler, JoinPoint joinPoint) throws Throwable {
        Method currentMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object target = joinPoint.getTarget();
        Method handleMethod = null;
        try {
            handleMethod = joinPoint.getTarget().getClass().getDeclaredMethod(releaseTimeoutHandler, currentMethod.getParameterTypes());
            handleMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Illegal annotation param customReleaseTimeoutStrategy", e);
        }
        Object[] args = joinPoint.getArgs();
        try {
            handleMethod.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new KlockInvocationException("Fail to invoke custom release timeout handler: " + releaseTimeoutHandler, e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private void cleanUpThreadLocal() {
        this.currentThreadLock.remove();
    }

    private class LockRes {
        private LockInfo lockInfo;
        private Lock lock;
        private Boolean res;

        LockRes(LockInfo lockInfo, Boolean res) {
            this.lockInfo = lockInfo;
            this.res = res;
        }

        LockInfo getLockInfo() {
            return this.lockInfo;
        }

        public Lock getLock() {
            return this.lock;
        }

        public void setLock(Lock lock) {
            this.lock = lock;
        }

        Boolean getRes() {
            return this.res;
        }

        void setRes(Boolean res) {
            this.res = res;
        }

        void setLockInfo(LockInfo lockInfo) {
            this.lockInfo = lockInfo;
        }
    }
}

