/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;

public class UpdateQueryBuilder {
    private String id;
    private UpdateRequest updateRequest;
    private IndexRequest indexRequest;
    private String indexName;
    private String type;
    private Class clazz;
    private boolean doUpsert;

    public UpdateQueryBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public UpdateQueryBuilder withUpdateRequest(UpdateRequest updateRequest) {
        this.updateRequest = updateRequest;
        return this;
    }

    public UpdateQueryBuilder withIndexRequest(IndexRequest indexRequest) {
        this.indexRequest = indexRequest;
        return this;
    }

    public UpdateQueryBuilder withIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public UpdateQueryBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public UpdateQueryBuilder withClass(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public UpdateQueryBuilder withDoUpsert(boolean doUpsert) {
        this.doUpsert = doUpsert;
        return this;
    }

    public UpdateQuery build() {
        UpdateQuery updateQuery = new UpdateQuery();
        updateQuery.setId(this.id);
        updateQuery.setIndexName(this.indexName);
        updateQuery.setType(this.type);
        updateQuery.setClazz(this.clazz);
        if (this.indexRequest != null) {
            if (this.updateRequest == null) {
                this.updateRequest = new UpdateRequest();
            }
            this.updateRequest.doc(this.indexRequest);
        }
        updateQuery.setUpdateRequest(this.updateRequest);
        updateQuery.setDoUpsert(this.doUpsert);
        return updateQuery;
    }
}

