/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoThroughput;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultThroughput;
import com.sap.conn.jco.rt.JCoRuntimeFactory;

abstract class InternalDestination
implements JCoDestination,
ConnectionAttributes.CPICBasedConnection {
    static final String JCO_DESTINATION_USERID = "jco.destination.userid";
    private boolean inPasswordChangeHandler = false;
    private DefaultThroughput throughput = null;
    private String userId = null;

    InternalDestination() {
    }

    abstract void execute(AbapFunction var1) throws JCoException;

    abstract void execute(AbapFunctionUnit var1) throws JCoException;

    abstract void execute(AbapFunction var1, String var2, String var3) throws JCoException;

    public abstract String getDestinationID();

    public String getOriginDestinationID(boolean repositoryFactory) {
        return null;
    }

    Boolean supportsTurboRepository() {
        return new Boolean(false);
    }

    abstract String getRepositoryKey();

    abstract String getScopeType();

    abstract String getSystemID() throws JCoException;

    public DefaultThroughput getThroughput() {
        return this.throughput;
    }

    public void removeThroughput() {
        this.throughput = null;
    }

    public void setThroughput(JCoThroughput aThroughput) throws JCoRuntimeException {
        try {
            this.throughput = (DefaultThroughput)aThroughput;
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Illegal instance passed to setThroughput() - use JCo.createThroughput()");
        }
    }

    String getUserId() {
        return this.userId;
    }

    void setUserId(String userID) {
        this.userId = userID;
    }

    public JCoDestinationMonitor getMonitor() {
        return null;
    }

    public JCoDestinationMonitor getRepositoryDestinationMonitor() {
        return null;
    }

    InternalDestination getRepositoryDestination() throws JCoException {
        return null;
    }

    Context getCurrentContext() {
        return JCoRuntimeFactory.getRuntime().getRuntimeContext(null);
    }

    public String getConversationID() {
        Context ctx = this.getCurrentContext();
        if (ctx != null) {
            Context.DestinationEntry destEntry = ctx.connToDest.get(this.getDestinationID());
            if (destEntry != null && destEntry.conn != null) {
                return destEntry.conn.getConversationID();
            }
            return "00000000";
        }
        return "<unknown>";
    }

    public void confirmFunctionUnit(JCoUnitIdentifier unitIdentifier) throws JCoException {
        throw new UnsupportedOperationException("confirmFunctionUnit() is only supported on RFC destinations");
    }

    public JCoFunctionUnitState getFunctionUnitState(JCoUnitIdentifier unitIdentifier) throws JCoException {
        throw new UnsupportedOperationException("getFunctionUnitState() is only supported on RFC destinations");
    }

    public abstract void ping() throws JCoException;

    public boolean isValid() {
        return true;
    }

    final void setInPasswordChangeHandler(boolean isInPasswordChangeHandler) {
        this.inPasswordChangeHandler = isInPasswordChangeHandler;
    }

    final boolean isInPasswordChangeHandler() {
        return this.inPasswordChangeHandler;
    }
}

