/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.json.JSonWriter;
import java.io.IOException;

public class JSonContainerWriter {
    JSonWriter writer;

    JSonContainerWriter(JSonWriter w) {
        this.setWriter(w);
    }

    void setWriter(JSonWriter writer) {
        this.writer = writer;
    }

    void writeField(AbstractMetaData md, int i) throws IOException {
        this.writer.writeLine();
        this.writer.write("\t\t\t{");
        this.writer.writeNVPair("name", md.getName(i));
        this.writeFieldProperties(md, i);
        this.writer.write(125);
    }

    void writeSpecificProperties(AbstractMetaData md, int i) throws IOException {
    }

    void writeFieldProperties(AbstractMetaData md, int i) throws IOException {
        this.writeSpecificProperties(md, i);
        this.writer.writeSubsequentPair("doc", md.getDescription(i));
        int type = md.getType(i);
        this.writer.writeSubsequentPair("abapType", AbstractMetaData.getJCOTypeChar(type));
        this.writer.writeSubsequentPair("ddicName", md.getRecordTypeName(i));
        if (md.isStructure(i) || md.isTable(i)) {
            this.writer.writeSubsequentPair("nucLength", md.getByteLength(i));
            this.writer.writeSubsequentPair("ucLength", md.getUnicodeByteLength(i));
        } else if (!(md.isAbapObject(i) || type != 2 && type != 0 && type != 6 && type != 4)) {
            this.writer.writeSubsequentPair("nucLength", md.getByteLength(i));
            this.writer.writeSubsequentPair("ucLength", md.getUnicodeByteLength(i));
            if (type == 2) {
                this.writer.writeSubsequentPair("decimals", md.getDecimals(i));
            }
        }
    }
}

