/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.decfloat;

import com.sap.i18n.decfloat.DPDTable;
import com.sap.i18n.decfloat.DecFloatOverflowException;
import com.sap.i18n.decfloat.DecFloatType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;

public class DecFloat {
    private static final byte[] COMBEXP = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 1, 1, 2, 2, 3, 3};
    private static final byte[] COMBMSD = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 9, 8, 9, 0, 1};
    public static final int c_DecFloat16Len = 8;
    public static final int c_DecFloat34Len = 16;
    private static final char COMB = '\u001f';
    private static final short c_DECIMAL64_PMax = 16;
    private static final short c_DECIMAL64_Bias = 398;
    private static final short c_DECIMAL64_EMin = -383;
    private static final short c_DECIMAL64_EMax = 384;
    private static final short c_DECIMAL64_EHigh = 767;
    private static final short c_DECIMAL128_PMax = 34;
    private static final short c_DECIMAL128_Bias = 6176;
    private static final short c_DECIMAL128_EMin = -6143;
    private static final short c_DECIMAL128_EMax = 6144;
    private static final short c_DECIMAL128_EHigh = 12287;
    private static final short c_MAX_STRING_LEN = 43;

    private static StringBuilder DPDdecletsToStringBuilder(long[] coeff, int NumOfCoeff, int NumOfDeclets) {
        StringBuilder result = new StringBuilder(NumOfDeclets * 3);
        short dpd = 0;
        short[] bcd = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int shift = 0;
        int k = 0;
        int n = 0;
        for (n = 0; n < NumOfDeclets; ++n) {
            dpd = (short)(coeff[NumOfCoeff - 1 - k] >> shift);
            if ((shift += 10) > 32) {
                dpd = (short)(dpd | (short)(coeff[NumOfCoeff - 1 - ++k] << 10 - (shift -= 32)));
            }
            dpd = (short)(dpd & 0x3FF);
            bcd[n] = DPDTable.DPD2BCD(dpd);
        }
        boolean trailing_zeros = false;
        boolean first = true;
        --n;
        while (n >= 0) {
            if (bcd[n] != 0 || trailing_zeros) {
                trailing_zeros = true;
                if (first) {
                    if ((bcd[n] & 0xF00) == 0 && (bcd[n] & 0xF0) == 0) {
                        result.append(bcd[n] & 0xF);
                    } else if ((bcd[n] & 0xF00) == 0) {
                        result.append((bcd[n] & 0xF0) >> 4);
                        result.append(bcd[n] & 0xF);
                    } else {
                        result.append((bcd[n] & 0xF00) >> 8);
                        result.append((bcd[n] & 0xF0) >> 4);
                        result.append(bcd[n] & 0xF);
                    }
                    first = false;
                } else {
                    result.append((bcd[n] & 0xF00) >> 8);
                    result.append((bcd[n] & 0xF0) >> 4);
                    result.append(bcd[n] & 0xF);
                }
            }
            --n;
        }
        return result;
    }

    private static void PackUnscaledValue(String UnscalVal, long[] target, int numOfTargetComps) {
        int numOfDeclets = UnscalVal.length() / 3;
        int rest = UnscalVal.length() - numOfDeclets * 3;
        int bcd = 0;
        int curTargetIdx = 0;
        int curShift = 0;
        int i = 1;
        for (i = 0; i < numOfDeclets + 1; ++i) {
            if (i < numOfDeclets) {
                bcd |= Character.digit(UnscalVal.charAt(UnscalVal.length() - 3 * i - 3), 10) << 8;
            }
            if (i < numOfDeclets || rest == 2) {
                bcd |= Character.digit(UnscalVal.charAt(UnscalVal.length() - 3 * i - 2), 10) << 4;
            }
            if (i < numOfDeclets || rest == 2 || rest == 1) {
                bcd |= Character.digit(UnscalVal.charAt(UnscalVal.length() - 3 * i - 1), 10);
            }
            if (curShift + 10 <= 30) {
                int n = numOfTargetComps - curTargetIdx - 1;
                target[n] = target[n] | (long)((DPDTable.BCD2DPD[bcd] & 0x3FF) << curShift);
                curShift += 10;
            } else if (curTargetIdx == 0) {
                int n = numOfTargetComps - curTargetIdx - 1;
                target[n] = target[n] | (long)((DPDTable.BCD2DPD[bcd] & 3) << 30);
                int n2 = numOfTargetComps - ++curTargetIdx - 1;
                target[n2] = target[n2] | (long)((DPDTable.BCD2DPD[bcd] & 0x3FC) >> 2);
                curShift = 8;
            } else if (curTargetIdx == 1) {
                int n = numOfTargetComps - curTargetIdx - 1;
                target[n] = target[n] | (long)((DPDTable.BCD2DPD[bcd] & 0xF) << 28);
                int n3 = numOfTargetComps - ++curTargetIdx - 1;
                target[n3] = target[n3] | (long)((DPDTable.BCD2DPD[bcd] & 0x3F0) >> 4);
                curShift = 6;
            } else if (curTargetIdx == 2) {
                int n = numOfTargetComps - curTargetIdx - 1;
                target[n] = target[n] | (long)((DPDTable.BCD2DPD[bcd] & 0x3F) << 26);
                int n4 = numOfTargetComps - ++curTargetIdx - 1;
                target[n4] = target[n4] | (long)((DPDTable.BCD2DPD[bcd] & 0x3C0) >> 6);
                curShift = 4;
            } else if (curTargetIdx == 3) {
                int n = numOfTargetComps - curTargetIdx - 1;
                target[n] = target[n] | (long)((DPDTable.BCD2DPD[bcd] & 0xFF) << 24);
                int n5 = numOfTargetComps - ++curTargetIdx - 1;
                target[n5] = target[n5] | (long)((DPDTable.BCD2DPD[bcd] & 0x300) >> 8);
                curShift = 2;
            }
            bcd = 0;
        }
    }

    public static BigDecimal toBigDecimal(DecFloatType type, byte[] in, int startIndex, int length) {
        String number = DecFloat.toString(type, in, startIndex, length);
        if (type.equals(DecFloatType.DECFLOAT16_LE) || type.equals(DecFloatType.DECFLOAT16_BE)) {
            return new BigDecimal(number, MathContext.DECIMAL64);
        }
        if (type.equals(DecFloatType.DECFLOAT34_LE) || type.equals(DecFloatType.DECFLOAT34_BE)) {
            return new BigDecimal(number, MathContext.DECIMAL128);
        }
        return BigDecimal.ZERO;
    }

    public static void fromBigDecimal(DecFloatType type, BigDecimal in, byte[] out, int startIndex, int length) {
        block31: {
            int i;
            block30: {
                int i2;
                if (!type.equals(DecFloatType.DECFLOAT16_LE) && !type.equals(DecFloatType.DECFLOAT16_BE)) break block30;
                BigDecimal bdNumber = new BigDecimal(in.unscaledValue(), in.scale(), MathContext.DECIMAL64);
                String significandStr = bdNumber.unscaledValue().toString();
                boolean isNegative = false;
                int unBiasedExp = -bdNumber.scale();
                int biasedExp = 0;
                short comb = 0;
                if (bdNumber.unscaledValue().compareTo(BigInteger.ZERO) < 0) {
                    significandStr = bdNumber.unscaledValue().abs().toString();
                    isNegative = true;
                }
                long[] targar = new long[]{0L, 0L};
                if (unBiasedExp < -398) {
                    in = BigDecimal.ZERO;
                }
                if (in.compareTo(BigDecimal.ZERO) == 0) {
                    if (unBiasedExp < -398) {
                        biasedExp = 0;
                    } else {
                        biasedExp = unBiasedExp + 398;
                        if (biasedExp > 767) {
                            biasedExp = 767;
                        }
                    }
                    comb = (short)(biasedExp >> 5 & 0x18);
                } else {
                    if (unBiasedExp > 384) {
                        throw new DecFloatOverflowException("Decfloat16 Overflow: Exponent=" + unBiasedExp + " is out of range [" + -383 + "..." + 384 + "]. ");
                    }
                    biasedExp = unBiasedExp + 398;
                    int msd = 0;
                    if (biasedExp > 767) {
                        int pad = biasedExp - 767;
                        biasedExp = 767;
                        for (int i3 = 0; i3 < pad; ++i3) {
                            significandStr = significandStr + '0';
                        }
                    }
                    DecFloat.PackUnscaledValue(significandStr, targar, 2);
                    msd = (int)(targar[0] >> 18);
                    targar[0] = targar[0] & 0x3FFFFL;
                    comb = msd >= 8 ? (short)(0x18 | biasedExp >> 7 & 6 | msd & 1) : (short)(biasedExp >> 5 & 0x18 | msd);
                }
                targar[0] = targar[0] | (long)(comb << 26);
                targar[0] = targar[0] | (long)((biasedExp & 0xFF) << 18);
                if (isNegative) {
                    targar[0] = targar[0] | Integer.MIN_VALUE;
                }
                if (type.equals(DecFloatType.DECFLOAT16_BE)) {
                    for (i2 = 4; i2 > 0; --i2) {
                        out[startIndex + 4 - i2] = (byte)(targar[0] >> (i2 - 1) * 8 & 0xFFL);
                        out[startIndex + 8 - i2] = (byte)(targar[1] >> (i2 - 1) * 8 & 0xFFL);
                    }
                } else {
                    for (i2 = 0; i2 < 4; ++i2) {
                        out[startIndex + 4 + i2] = (byte)(targar[0] >> i2 * 8 & 0xFFL);
                        out[startIndex + i2] = (byte)(targar[1] >> i2 * 8 & 0xFFL);
                    }
                }
                break block31;
            }
            if (!type.equals(DecFloatType.DECFLOAT34_LE) && !type.equals(DecFloatType.DECFLOAT34_BE)) break block31;
            BigDecimal bdNumber = new BigDecimal(in.unscaledValue(), in.scale(), MathContext.DECIMAL128);
            String significandStr = bdNumber.unscaledValue().toString();
            boolean isNegative = false;
            int unBiasedExp = -bdNumber.scale();
            int biasedExp = 0;
            short comb = 0;
            if (bdNumber.unscaledValue().compareTo(BigInteger.ZERO) < 0) {
                significandStr = bdNumber.unscaledValue().abs().toString();
                isNegative = true;
            }
            long[] targar = new long[]{0L, 0L, 0L, 0L};
            if (unBiasedExp < -6176) {
                in = BigDecimal.ZERO;
            }
            if (in.compareTo(BigDecimal.ZERO) == 0) {
                if (unBiasedExp < -6176) {
                    biasedExp = 0;
                } else {
                    biasedExp = unBiasedExp + 6176;
                    if (biasedExp > 12287) {
                        biasedExp = 12287;
                    }
                }
                comb = (short)(biasedExp >> 9 & 0x18);
            } else {
                if (unBiasedExp > 6144) {
                    throw new DecFloatOverflowException("Decfloat34 Overflow: Exponent=" + unBiasedExp + " is out of range [" + -6143 + "..." + 6144 + "]. ");
                }
                biasedExp = unBiasedExp + 6176;
                int msd = 0;
                if (biasedExp > 12287) {
                    int pad = biasedExp - 12287;
                    biasedExp = 12287;
                    for (int i4 = 0; i4 < pad; ++i4) {
                        significandStr = significandStr + '0';
                    }
                }
                DecFloat.PackUnscaledValue(significandStr, targar, 4);
                msd = (int)(targar[0] >> 14);
                targar[0] = targar[0] & 0x3FFFL;
                comb = msd >= 8 ? (short)(0x18 | biasedExp >> 11 & 6 | msd & 1) : (short)(biasedExp >> 9 & 0x18 | msd);
            }
            targar[0] = targar[0] | (long)(comb << 26);
            targar[0] = targar[0] | (long)((biasedExp & 0xFFF) << 14);
            if (isNegative) {
                targar[0] = targar[0] | Integer.MIN_VALUE;
            }
            if (type.equals(DecFloatType.DECFLOAT34_BE)) {
                for (i = 4; i > 0; --i) {
                    out[startIndex + 4 - i] = (byte)(targar[0] >> (i - 1) * 8 & 0xFFL);
                    out[startIndex + 8 - i] = (byte)(targar[1] >> (i - 1) * 8 & 0xFFL);
                    out[startIndex + 12 - i] = (byte)(targar[2] >> (i - 1) * 8 & 0xFFL);
                    out[startIndex + 16 - i] = (byte)(targar[3] >> (i - 1) * 8 & 0xFFL);
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    out[startIndex + 12 + i] = (byte)(targar[0] >> i * 8 & 0xFFL);
                    out[startIndex + 8 + i] = (byte)(targar[1] >> i * 8 & 0xFFL);
                    out[startIndex + 4 + i] = (byte)(targar[2] >> i * 8 & 0xFFL);
                    out[startIndex + i] = (byte)(targar[3] >> i * 8 & 0xFFL);
                }
            }
        }
    }

    public static String toString(DecFloatType type, byte[] in, int startIndex, int length) {
        StringBuilder result = new StringBuilder(43);
        short[] exponent = new short[]{0};
        boolean[] isNegative = new boolean[]{false};
        if (DecFloat.decodeBytes(type, in, startIndex, length, result, exponent, isNegative)) {
            if (result.length() == 0) {
                result.append('0');
            }
            result.append('E').append(exponent[0]);
        }
        if (isNegative[0]) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    public static String toPlainString(DecFloatType type, byte[] in, int startIndex, int length) {
        StringBuilder result = new StringBuilder(43);
        short[] exponent = new short[]{0};
        boolean[] isNegative = new boolean[]{false};
        if (DecFloat.decodeBytes(type, in, startIndex, length, result, exponent, isNegative)) {
            if (exponent[0] != 0) {
                int len = result.length();
                int pointPos = len + exponent[0];
                if (pointPos == 0) {
                    result.insert(0, "0.");
                } else if (pointPos < 0) {
                    char[] zeros = new char[-pointPos];
                    Arrays.fill(zeros, '0');
                    result.insert(0, zeros);
                    result.insert(0, "0.");
                } else if (pointPos > len) {
                    char[] zeros = new char[exponent[0]];
                    Arrays.fill(zeros, '0');
                    result.append(zeros);
                    if (len == 0) {
                        result.append('0');
                    }
                } else {
                    result.insert(pointPos, '.');
                }
            } else if (result.length() == 0) {
                result.append("0");
            }
        }
        if (isNegative[0]) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    private static boolean decodeBytes(DecFloatType type, byte[] in, int startIndex, int length, StringBuilder number, short[] exponent, boolean[] isNegativ) {
        boolean isSpecial = false;
        if (type.equals(DecFloatType.DECFLOAT16_LE) || type.equals(DecFloatType.DECFLOAT16_BE)) {
            int i;
            long sourcehi = 0L;
            long sourcelo = 0L;
            if (type.equals(DecFloatType.DECFLOAT16_LE)) {
                for (i = 0; i < 4; ++i) {
                    sourcehi |= ((long)in[startIndex + i + 4] & 0xFFL) << i * 8;
                    sourcelo |= ((long)in[startIndex + i] & 0xFFL) << i * 8;
                }
            } else if (type.equals(DecFloatType.DECFLOAT16_BE)) {
                for (i = 0; i < 4; ++i) {
                    sourcehi |= ((long)in[startIndex + i] & 0xFFL) << (3 - i) * 8;
                    sourcelo |= ((long)in[startIndex + i + 4] & 0xFFL) << (3 - i) * 8;
                }
            }
            short comb = (short)(sourcehi >> 26 & 0x1FL);
            if (sourcehi >> 31 != 0L) {
                isNegativ[0] = true;
            }
            short msd = COMBMSD[comb];
            short exp = COMBEXP[comb];
            if (exp == 3) {
                if (msd == 0) {
                    number.append("Inf");
                    return false;
                }
                if ((sourcehi >> 24 & 2L) != 0L) {
                    number.append("sNaN");
                } else {
                    number.append("NaN");
                }
                msd = 0;
                isSpecial = true;
            } else {
                exponent[0] = (short)((short)(exp << 8) + (short)(sourcehi >> 18 & 0xFFL) - 398);
            }
            int need = 0;
            sourcehi &= 0x3FFFFL;
            if (msd != 0) {
                sourcehi |= (long)(msd << 18);
                need = 6;
            } else if (sourcehi == 0L) {
                if (sourcelo == 0L) {
                    return !isSpecial;
                }
                need = 3;
                if ((sourcelo & 0xFFFFFFFFC0000000L) != 0L) {
                    ++need;
                }
            } else {
                need = 4;
                if ((sourcehi & 0x3FF00L) != 0L) {
                    ++need;
                }
            }
            long[] coeff = new long[]{sourcehi, sourcelo};
            number.append((CharSequence)DecFloat.DPDdecletsToStringBuilder(coeff, 2, need));
        } else if (type.equals(DecFloatType.DECFLOAT34_LE) || type.equals(DecFloatType.DECFLOAT34_BE)) {
            int i;
            long sourcehihi = 0L;
            long sourcehilo = 0L;
            long sourcelohi = 0L;
            long sourcelolo = 0L;
            if (type.equals(DecFloatType.DECFLOAT34_LE)) {
                for (i = 0; i < 4; ++i) {
                    sourcehihi |= ((long)in[startIndex + i + 12] & 0xFFL) << i * 8;
                    sourcehilo |= ((long)in[startIndex + i + 8] & 0xFFL) << i * 8;
                    sourcelohi |= ((long)in[startIndex + i + 4] & 0xFFL) << i * 8;
                    sourcelolo |= ((long)in[startIndex + i] & 0xFFL) << i * 8;
                }
            } else if (type.equals(DecFloatType.DECFLOAT34_BE)) {
                for (i = 0; i < 4; ++i) {
                    sourcehihi |= ((long)in[startIndex + i] & 0xFFL) << (3 - i) * 8;
                    sourcehilo |= ((long)in[startIndex + i + 4] & 0xFFL) << (3 - i) * 8;
                    sourcelohi |= ((long)in[startIndex + i + 8] & 0xFFL) << (3 - i) * 8;
                    sourcelolo |= ((long)in[startIndex + i + 12] & 0xFFL) << (3 - i) * 8;
                }
            }
            short comb = (short)(sourcehihi >> 26 & 0x1FL);
            if (sourcehihi >> 31 != 0L) {
                isNegativ[0] = true;
            }
            short msd = COMBMSD[comb];
            short exp = COMBEXP[comb];
            if (exp == 3) {
                if (msd == 0) {
                    number.append("Inf");
                    return false;
                }
                if ((sourcehihi >> 24 & 2L) != 0L) {
                    number.append("sNaN");
                } else {
                    number.append("NaN");
                }
                msd = 0;
                isSpecial = true;
            } else {
                exponent[0] = (short)((short)(exp << 12) + (short)(sourcehihi >> 14 & 0xFFFL) - 6176);
            }
            int need = 0;
            sourcehihi &= 0x3FFFL;
            if (msd != 0) {
                sourcehihi |= (long)(msd << 14);
                need = 12;
            } else if (sourcehihi != 0L) {
                need = 11;
            } else if (sourcehilo != 0L) {
                need = 10;
            } else if (sourcelohi != 0L) {
                need = 7;
            } else if (sourcelolo != 0L) {
                need = 4;
            } else {
                return !isSpecial;
            }
            long[] coeff = new long[]{sourcehihi, sourcehilo, sourcelohi, sourcelolo};
            number.append((CharSequence)DecFloat.DPDdecletsToStringBuilder(coeff, 4, need));
        } else {
            throw new IllegalArgumentException("Conversion failed, because the type " + type.toString() + " is unknown. Reinstallation of the decFloat package is required");
        }
        return !isSpecial;
    }

    public static void fromString(DecFloatType type, String in, byte[] out, int startIndex, int length) {
        BigDecimal bd = BigDecimal.ZERO;
        if (type.equals(DecFloatType.DECFLOAT16_LE) || type.equals(DecFloatType.DECFLOAT16_BE)) {
            bd = new BigDecimal(in, MathContext.DECIMAL64);
        } else if (type.equals(DecFloatType.DECFLOAT34_LE) || type.equals(DecFloatType.DECFLOAT34_BE)) {
            bd = new BigDecimal(in, MathContext.DECIMAL128);
        }
        DecFloat.fromBigDecimal(type, bd, out, startIndex, length);
    }

    public static int sizeof(DecFloatType type) {
        if (type.equals(DecFloatType.DECFLOAT16_LE) || type.equals(DecFloatType.DECFLOAT16_BE)) {
            return 8;
        }
        if (type.equals(DecFloatType.DECFLOAT34_LE) || type.equals(DecFloatType.DECFLOAT34_BE)) {
            return 16;
        }
        return 0;
    }
}

