/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.decfloat;

import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatOverflowException;
import com.sap.i18n.decfloat.DecFloatType;
import com.sap.i18n.decfloat.StringUtil;
import com.sap.i18n.verify.intf.VerifyIntf;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Date;
import java.util.Random;

public class DecFloatTImpl {
    final byte[] DecFloat16ByteArr = new byte[]{1, 0, 0, 0, 0, 0, 56, 34, 34, 56, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 56, -94, -94, 56, 0, 0, 0, 0, 0, 1, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 34, 56, 0, 0, 10, 57, 91, -49, 52, 5, 0, 0, 0, 0, 120, 35, -93, 0, 0, 0, 0, 0, 0, 124, 0, 0, 0, 0, 0, 0, 0, 124, 0, 0, 0, 0, 0, 0, 0, 126, 0, 0, 0, 0, 0, 0, 0, 120, -1, -4, -13, -49, 63, -1, -4, 119, 0, 0, 0, 0, 0, 0, -8, 71, 0, 0, 0, 0, 0, 0, -12, 75, 2, 0, 0, 0, 0, 0, 68, 34, 25, 0, 0, 0, 0, 0, 64, 34, 0, 0, -112, 1, 0, 0, 40, 34, 25, 0, 0, 0, 0, 0, 60, 34, -1, -4, -13, -49, 63, 127, 4, 38, 24, 0, 0, 0, 0, 0, 60, 34, 1, 0, 0, 0, 0, 12, -4, 37, 24, 0, 0, 0, 0, 0, 52, 34, 1, 0, 0, 0, 0, 0, 56, 34, 10, 0, 0, 0, 0, 0, 48, 34, 121, 0, 0, 0, 0, 0, 48, 34, 24, 0, 0, 0, 0, 0, 48, 34, -1, -4, -13, -49, 63, -33, -5, 37, 1, 0, 0, 0, 0, 0, 60, 0, -1, -4, -13, -49, 63, -1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 34, 0, 0, 0, 0, 0, 0, 56, 34, 0, 0, 0, 0, 0, 0, 48, 34, 0, 0, 0, 0, 0, 0, 48, 34, 0, 0, 0, 0, 0, 0, 40, 34, 0, 0, 0, 0, 0, 0, 112, 33, 0, 0, 0, 0, 0, 0, 112, -95, 0, 0, 0, 0, 0, 0, 40, -94, 0, 0, 0, 0, 0, 0, 48, -94, 0, 0, 0, 0, 0, 0, 48, -94, 0, 0, 0, 0, 0, 0, 56, -94, 1, 0, 0, 0, 0, 0, 0, -128, 23, 0, 0, 0, 0, 0, 44, -94, 23, 0, 0, 0, 0, 0, 48, -94, 1, 0, 0, 0, 0, 0, 56, -94, 1, 0, 0, 0, 0, -128, -5, -91, -1, -4, -13, -49, 63, -33, -5, -91, 24, 0, 0, 0, 0, 0, 48, -94, 24, 0, 0, 0, 0, 0, 52, -94, -1, -4, -13, -49, 63, -33, 7, -90, 24, 0, 0, 0, 0, 0, 60, -94, 1, 0, 0, 0, 0, 12, 4, -90, 25, 0, 0, 0, 0, 0, 64, -94, -1, -4, -13, -49, 63, -1, -4, -9, 0, 0, 0, 0, 0, 0, 0, -8, 0, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, -4, -1, -4, -13, -49, 63, -1, 0, -4, 81, 16, -56, -62, 0, 0, -60, -126, 0, -32, 88, -102, -64, 4, -4, -61, 32, -85, 101, 40, 0, 0, 120, 35, 6, -83, -57, 43, 0, 0, -72, -95, -68, 34, -56, 13, 0, 0, -76, -127, -29, 54, -26, 41, 0, 0, -96, -94, -16, -3, -88, 24, 4, 0, -4, -61, 0, 0, 0, 0, 0, 0, 64, -94};
    final byte[] DecFloat34ByteArr = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 34, 34, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, -94, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -4, -13, -49, 63, -1, -4, -13, -49, 63, -1, -4, -13, 15, 0, -4, -1, -4, -13, -49, 63, -1, -4, -13, -49, 63, -1, -4, -13, -49, -1, 119, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, 8, 34, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 8, 34, 0, 0, -112, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 34, -93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124};
    private VerifyIntf m_oVerify;

    public DecFloatTImpl(VerifyIntf oVerify) {
        this.m_oVerify = oVerify;
    }

    private void verify(boolean bCond, String sErrText, String sTestName) {
        this.m_oVerify.verifyTest(bCond, sErrText, sTestName);
    }

    private void printLogln(String sLogText) {
        this.m_oVerify.printLogln(sLogText);
    }

    public void testMain() {
        this.printLogln("Testing DecFloat -> String conversion :");
        this.testDecFloatToStringConversion();
        this.printLogln("Testing DecFloat -> plain String conversion :");
        this.testDecFloatToPlainStringConversion();
        this.printLogln("done.");
        this.printLogln("Testing DecFloat -> BigDecimal conversion :");
        this.testDecFloatToBigDecimal();
        this.printLogln("done.");
        this.printLogln("Testing DecFloat <- BigDecimal conversion :");
        this.testBigDecimalToDecFloat();
        this.printLogln("done.");
        this.printLogln("Testing DecFloat <- String conversion :");
        this.testStringToDecFloat();
        this.printLogln("done.");
        this.printLogln("Testing DecFloat <-> BigDecimal conversion ");
        this.testRoundTrip();
        this.printLogln("done.");
        this.printLogln("Testing DecFloat <-> BigDecimal conversion randomly");
        this.testRoundTripRandomly();
        new StringUtil();
        this.printLogln("done.");
    }

    private void verifyStrings(String result, String expected, String checkName) {
        this.verify(result.equals(expected), checkName + ": expected string = " + expected + ", result = " + result, checkName);
    }

    private boolean catchNumberFormatException(DecFloatType type, byte[] in, int startIdx, int len, boolean shouldBeException) {
        boolean valid;
        block3: {
            valid = false;
            try {
                DecFloat.toBigDecimal(type, in, startIdx, len);
                if (!shouldBeException) {
                    valid = true;
                }
            }
            catch (NumberFormatException e) {
                if (!shouldBeException) break block3;
                valid = true;
            }
        }
        return valid;
    }

    private boolean catchDecFloatOverflowException(DecFloatType type, BigDecimal in, byte[] out, int startIdx, int len, boolean shouldBeException) {
        boolean valid;
        block3: {
            valid = false;
            try {
                DecFloat.fromBigDecimal(type, in, out, startIdx, len);
                if (!shouldBeException) {
                    valid = true;
                }
            }
            catch (DecFloatOverflowException e) {
                if (!shouldBeException) break block3;
                valid = true;
            }
        }
        return valid;
    }

    private boolean catchDecFloatOverflowException2(DecFloatType type, String in, byte[] out, int startIdx, int len, boolean shouldBeException) {
        boolean valid;
        block3: {
            valid = false;
            try {
                DecFloat.fromString(type, in, out, startIdx, len);
                if (!shouldBeException) {
                    valid = true;
                }
            }
            catch (DecFloatOverflowException e) {
                if (!shouldBeException) break block3;
                valid = true;
            }
        }
        return valid;
    }

    public void testDecFloatToStringConversion() {
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 0, 8), "1E0", "DF16_LE: 1");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 8, 8), "1E0", "DF16_BE: 2");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 16, 8), "-1E0", "DF16_LE: 3");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 24, 8), "-1E0", "DF16_BE: 4");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 32, 8), "Inf", "DF16_BE: 5");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 40, 8), "Inf", "DF16_LE: 6");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 48, 8), "NaN", "DF16_BE: 7");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 56, 8), "NaN", "DF16_LE: 8");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 64, 8), "sNaN", "DF16_BE: 9");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 72, 8), "sNaN", "DF16_LE: 10");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 80, 8), "123456789E0", "DF16_BE: 11");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 88, 8), "1234E80", "DF16_LE: 12");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 0, 16), "1E0", "DF34_LE: 13");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_BE, this.DecFloat34ByteArr, 16, 16), "1E0", "DF34_BE: 14");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 32, 16), "NaN", "DF34_LE: 15");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 48, 16), "sNaN", "DF34_LE: 16");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 64, 16), "Inf", "DF34_LE: 17");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 80, 16), "0E5737", "DF34_LE: 18");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 96, 16), "-Inf", "DF34_LE: 19");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 112, 16), "-sNaN", "DF34_LE: 20");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 128, 16), "-NaN", "DF34_LE: 21");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 96, 8), "NaN123", "DF16_LE: 22");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 104, 8), "NaN", "DF16_LE: 23");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 112, 8), "sNaN", "DF16_LE: 24");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 120, 8), "Inf", "DF16_LE: 25");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 128, 8), "9999999999999999E369", "DF16_LE: 26");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 136, 8), "1000000000000000E368", "DF16_LE: 27");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 144, 8), "2000000000000000E367", "DF16_LE: 28");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 152, 8), "2E3", "DF16_LE: 29");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 160, 8), "19E2", "DF16_LE: 30");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 168, 8), "19000000E-4", "DF16_LE: 31");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 176, 8), "19E1", "DF16_LE: 32");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 184, 8), "1899999999999999E-13", "DF16_LE: 33");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 192, 8), "18E1", "DF16_LE: 34");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 200, 8), "1800000000000001E-15", "DF16_LE: 35");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 208, 8), "18E-1", "DF16_LE: 36");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 216, 8), "1E0", "DF16_LE: 37");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 224, 8), "80E-2", "DF16_LE: 38");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 232, 8), "79E-2", "DF16_LE: 39");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 240, 8), "18E-2", "DF16_LE: 40");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 248, 8), "1799999999999999E-16", "DF16_LE: 41");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 256, 8), "1E-383", "DF16_LE: 42");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 264, 8), "999999999999999E-398", "DF16_LE: 43");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 272, 8), "1E-398", "DF16_LE: 44");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 280, 8), "0E2", "DF16_LE: 45");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 288, 8), "0E0", "DF16_LE: 46");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 296, 8), "0E-2", "DF16_LE: 47");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 304, 8), "0E-2", "DF16_LE: 48");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 312, 8), "0E-4", "DF16_LE: 49");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 320, 8), "0E-50", "DF16_LE: 50");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 328, 8), "-0E-50", "DF16_LE: 51");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 336, 8), "-0E-4", "DF16_LE: 52");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 344, 8), "-0E-2", "DF16_LE: 53");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 352, 8), "-0E-2", "DF16_LE: 54");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 360, 8), "-0E0", "DF16_LE: 55");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 368, 8), "-1E-398", "DF16_LE: 56");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 376, 8), "-17E-3", "DF16_LE: 57");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 384, 8), "-17E-2", "DF16_LE: 58");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 392, 8), "-1E0", "DF16_LE: 59");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 400, 8), "-1700000000000001E-16", "DF16_LE: 60");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 408, 8), "-1799999999999999E-16", "DF16_LE: 61");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 416, 8), "-18E-2", "DF16_LE: 62");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 424, 8), "-18E-1", "DF16_LE: 63");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 432, 8), "-1799999999999999E-13", "DF16_LE: 64");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 440, 8), "-18E1", "DF16_LE: 65");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 448, 8), "-1800000000000001E-13", "DF16_LE: 66");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 456, 8), "-19E2", "DF16_LE: 67");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 464, 8), "-9999999999999999E369", "DF16_LE: 68");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 472, 8), "-Inf", "DF16_LE: 69");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 480, 8), "-sNaN", "DF16_LE: 70");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 488, 8), "-NaN", "DF16_LE: 71");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 496, 8), "-NaN999999999999999", "DF16_LE: 72");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 504, 8), "-3820404051E-221", "DF16_LE: 73");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 512, 8), "-4602325438000E369", "DF16_LE: 74");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 520, 8), "506286620E80", "DF16_LE: 75");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 528, 8), "-934387206E-32", "DF16_LE: 76");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 536, 8), "-950408934E-289", "DF16_LE: 77");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 544, 8), "-994903563E26", "DF16_LE: 78");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 552, 8), "-10380859370E369", "DF16_LE: 79");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 560, 8), "-0E2", "DF16_LE: 80");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 144, 16), "-NaN999999999999999999999999999999999", "DF34_LE: 81");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 160, 16), "9999999999999999999999999999999999E6111", "DF34_LE: 82");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 176, 16), "2E3", "DF34_LE: 83");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 192, 16), "19E2", "DF34_LE: 84");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 208, 16), "19000000E-4", "DF34_LE: 85");
        this.verifyStrings(DecFloat.toString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 224, 16), "NaN123", "DF34_LE: 85");
    }

    public void testDecFloatToPlainStringConversion() {
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 0, 8), "1", "DF16_LE: 1");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 8, 8), "1", "DF16_BE: 2");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 16, 8), "-1", "DF16_LE: 3");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 24, 8), "-1", "DF16_BE: 4");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 32, 8), "Inf", "DF16_BE: 5");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 40, 8), "Inf", "DF16_LE: 6");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 48, 8), "NaN", "DF16_BE: 7");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 56, 8), "NaN", "DF16_LE: 8");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 64, 8), "sNaN", "DF16_BE: 9");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 72, 8), "sNaN", "DF16_LE: 10");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 80, 8), "123456789", "DF16_BE: 11");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 96, 8), "NaN123", "DF16_LE: 22");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 152, 8), "2000", "DF16_LE: 29");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 160, 8), "1900", "DF16_LE: 30");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 168, 8), "1900.0000", "DF16_LE: 31");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 176, 8), "190", "DF16_LE: 32");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 184, 8), "189.9999999999999", "DF16_LE: 33");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 192, 8), "180", "DF16_LE: 34");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 200, 8), "1.800000000000001", "DF16_LE: 35");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 208, 8), "1.8", "DF16_LE: 36");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 216, 8), "1", "DF16_LE: 37");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 224, 8), "0.80", "DF16_LE: 38");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 232, 8), "0.79", "DF16_LE: 39");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 240, 8), "0.18", "DF16_LE: 40");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 248, 8), "0.1799999999999999", "DF16_LE: 41");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 280, 8), "000", "DF16_LE: 45");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 288, 8), "0", "DF16_LE: 46");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 296, 8), "0.00", "DF16_LE: 47");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 304, 8), "0.00", "DF16_LE: 48");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 312, 8), "0.0000", "DF16_LE: 49");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 336, 8), "-0.0000", "DF16_LE: 52");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 344, 8), "-0.00", "DF16_LE: 53");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 352, 8), "-0.00", "DF16_LE: 54");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 360, 8), "-0", "DF16_LE: 55");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 376, 8), "-0.017", "DF16_LE: 57");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 384, 8), "-0.17", "DF16_LE: 58");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 392, 8), "-1", "DF16_LE: 59");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 400, 8), "-0.1700000000000001", "DF16_LE: 60");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 408, 8), "-0.1799999999999999", "DF16_LE: 61");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 416, 8), "-0.18", "DF16_LE: 62");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 424, 8), "-1.8", "DF16_LE: 63");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 432, 8), "-179.9999999999999", "DF16_LE: 64");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 440, 8), "-180", "DF16_LE: 65");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 448, 8), "-180.0000000000001", "DF16_LE: 66");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 456, 8), "-1900", "DF16_LE: 67");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 472, 8), "-Inf", "DF16_LE: 69");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 480, 8), "-sNaN", "DF16_LE: 70");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 488, 8), "-NaN", "DF16_LE: 71");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 496, 8), "-NaN999999999999999", "DF16_LE: 72");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 560, 8), "-000", "DF16_LE: 80");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 144, 16), "-NaN999999999999999999999999999999999", "DF34_LE: 81");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 176, 16), "2000", "DF34_LE: 83");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 192, 16), "1900", "DF34_LE: 84");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 208, 16), "1900.0000", "DF34_LE: 85");
        this.verifyStrings(DecFloat.toPlainString(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 224, 16), "NaN123", "DF34_LE: 85");
    }

    void testDecFloatToBigDecimal() {
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 0, 8).toString(), "1", "DF16_LE: 1");
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 8, 8).toString(), "1", "DF16_BE: 2");
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 16, 8).toString(), "-1", "DF16_LE: 3");
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 24, 8).toString(), "-1", "DF16_BE: 4");
        this.verify(this.catchNumberFormatException(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 24, 8, false), "0", "DF16_BE: 4");
        this.verify(this.catchNumberFormatException(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 32, 8, true), "0", "DF16_BE: 5");
        this.verify(this.catchNumberFormatException(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 40, 8, true), "0", "DF16_LE: 6");
        this.verify(this.catchNumberFormatException(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 48, 8, true), "0", "DF16_BE: 7");
        this.verify(this.catchNumberFormatException(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 56, 8, true), "0", "DF16_LE: 8");
        this.verify(this.catchNumberFormatException(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 64, 8, true), "0", "DF16_BE: 9");
        this.verify(this.catchNumberFormatException(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 72, 8, true), "0", "DF16_LE: 10");
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT16_BE, this.DecFloat16ByteArr, 80, 8).toString(), "123456789", "DF16_BE: 11");
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT16_LE, this.DecFloat16ByteArr, 88, 8).toString(), "1.234E+83", "DF16_LE: 12");
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT34_LE, this.DecFloat34ByteArr, 0, 16).toString(), "1", "DF34_LE: 13");
        this.verifyStrings(DecFloat.toBigDecimal(DecFloatType.DECFLOAT34_BE, this.DecFloat34ByteArr, 16, 16).toString(), "1", "DF34_BE: 14");
    }

    void testBigDecimalToDecFloat() {
        byte[] out = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] out2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int c_DF16_LEN = 8;
        int c_DF34_LEN = 16;
        byte[] expected = new byte[]{67, -4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, 67, 67, -4, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 70, -23, 52, -71, -63, -30, -114, 86, -58, -23, 52, -71, -63, -30, -114, 86, 52, 53, -126, 119, 113, 18, 60, 111, -27, 40, 30, -100, 75, 19, 83, 38, 52, 53, -126, 119, 113, 18, 60, 111, -27, 40, 30, -100, 75, 19, 83, -90};
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_LE, new BigDecimal("123E+3", MathContext.DECIMAL64), out, 0, 8);
        this.verify(this.catchDecFloatOverflowException2(DecFloatType.DECFLOAT16_LE, "1E+384", out, 0, 16, false), "1E+384", "DF16_LE 1");
        this.verify(this.catchDecFloatOverflowException2(DecFloatType.DECFLOAT16_LE, "1E+385", out, 0, 8, true), "1E+385", "DF16_LE 1");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("0E+384", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 0, 8), "DFP16_BE 2");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("0E+385", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 0, 8), "DFP16_BE 3");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("0E-397", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 8, 8), "DFP16_BE 4");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("0E-398", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 16, 8), "DFP16_BE 5");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("1E-399", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 16, 8), "DFP16_BE 6");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_LE, new BigDecimal("0E+384", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 24, 8), "DFP16_LE 7");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("1E+370", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 32, 8), "DFP16_BE 8");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("1E-398", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 40, 8), "DFP16_BE 9");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("1234567890123456E+300", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 48, 8), "DFP16_BE 10");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT16_BE, new BigDecimal("-1234567890123456E+300", MathContext.DECIMAL64), out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 56, 8), "DFP16_BE 11");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT34_LE, new BigDecimal("1234567890123456789012345678901234E+300", MathContext.DECIMAL128), out2, 0, 16);
        this.verifyStrings(StringUtil.buildHexString(out2, 0, 16), StringUtil.buildHexString(expected, 64, 16), "DFP34_LE 12");
        DecFloat.fromBigDecimal(DecFloatType.DECFLOAT34_LE, new BigDecimal("-1234567890123456789012345678901234E+300", MathContext.DECIMAL128), out2, 0, 16);
        this.verifyStrings(StringUtil.buildHexString(out2, 0, 16), StringUtil.buildHexString(expected, 80, 16), "DFP34_LE 13");
    }

    void testStringToDecFloat() {
        byte[] out = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] out2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int c_DF16_LEN = 8;
        int c_DF34_LEN = 16;
        byte[] expected = new byte[]{67, -4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, 67, 67, -4, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 1, 70, -23, 52, -71, -63, -30, -114, 86, -58, -23, 52, -71, -63, -30, -114, 86, 52, 53, -126, 119, 113, 18, 60, 111, -27, 40, 30, -100, 75, 19, 83, 38, 52, 53, -126, 119, 113, 18, 60, 111, -27, 40, 30, -100, 75, 19, 83, -90, -128, -19, -64, 0, -89, 11, -103, -23, 100, -72, -35, 40, 116, -113, 35, 51};
        DecFloat.fromString(DecFloatType.DECFLOAT16_LE, "123E+3", out, 0, 8);
        this.verify(this.catchDecFloatOverflowException(DecFloatType.DECFLOAT16_LE, new BigDecimal("1E+384", MathContext.DECIMAL64), out, 0, 16, false), "1E+385", "DF16_LE 1");
        this.verify(this.catchDecFloatOverflowException(DecFloatType.DECFLOAT16_LE, new BigDecimal("1E+385", MathContext.DECIMAL64), out, 0, 8, true), "1E+385", "DF16_LE 1");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "0E+384", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 0, 8), "DFP16_BE 2");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "0E+385", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 0, 8), "DFP16_BE 3");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "0E-397", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 8, 8), "DFP16_BE 4");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "0E-398", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 16, 8), "DFP16_BE 5");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "1E-399", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 16, 8), "DFP16_BE 6");
        DecFloat.fromString(DecFloatType.DECFLOAT16_LE, "0E+384", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 24, 8), "DFP16_LE 7");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "1E+370", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 32, 8), "DFP16_BE 8");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "1E-398", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 40, 8), "DFP16_BE 9");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "1234567890123456E+300", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 48, 8), "DFP16_BE 10");
        DecFloat.fromString(DecFloatType.DECFLOAT16_BE, "-1234567890123456E+300", out, 0, 8);
        this.verifyStrings(StringUtil.buildHexString(out, 0, 8), StringUtil.buildHexString(expected, 56, 8), "DFP16_BE 11");
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "1234567890123456789012345678901234E+300", out2, 0, 16);
        this.verifyStrings(StringUtil.buildHexString(out2, 0, 16), StringUtil.buildHexString(expected, 64, 16), "DFP34_LE 12");
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "-1234567890123456789012345678901234E+300", out2, 0, 16);
        this.verifyStrings(StringUtil.buildHexString(out2, 0, 16), StringUtil.buildHexString(expected, 80, 16), "DFP34_LE 13");
        DecFloat.fromString(DecFloatType.DECFLOAT34_BE, "-29681467516828951121648748633E-5225", out2, 0, 16);
        this.verifyStrings(StringUtil.buildHexString(out2, 0, 16), StringUtil.buildHexString(expected, 96, 16), "DFP34_LE 13");
    }

    void testRoundTripRandomly() {
        String result;
        String number;
        String Exp;
        String exp_sign;
        int i;
        byte[] DecFloat34 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] DecFloat16 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        Date dt = new Date();
        Random rd = new Random(dt.getTime());
        for (i = 0; i < 10000; ++i) {
            exp_sign = "";
            Exp = "" + (int)(rd.nextDouble() * 6111.0);
            if (!rd.nextBoolean() && !Exp.equals("0")) {
                exp_sign = "-";
            }
            number = "" + rd.nextLong() + Math.abs(rd.nextInt()) + "E" + exp_sign + Exp;
            System.out.println("Input = " + number);
            DecFloat.fromString(DecFloatType.DECFLOAT34_LE, number, DecFloat34, 0, 16);
            result = DecFloat.toString(DecFloatType.DECFLOAT34_LE, DecFloat34, 0, 16);
            this.verifyStrings(result, number, "DFP34_LE random roundtrip " + i);
        }
        for (i = 0; i < 10000; ++i) {
            exp_sign = "";
            Exp = "" + (int)(rd.nextDouble() * 6111.0);
            if (!rd.nextBoolean() && !Exp.equals("0")) {
                exp_sign = "-";
            }
            number = "" + rd.nextLong() + Math.abs(rd.nextInt()) + "E" + exp_sign + Exp;
            System.out.println("Input = " + number);
            DecFloat.fromString(DecFloatType.DECFLOAT34_BE, number, DecFloat34, 0, 16);
            result = DecFloat.toString(DecFloatType.DECFLOAT34_BE, DecFloat34, 0, 16);
            this.verifyStrings(result, number, "DFP34_BE random roundtrip " + i);
        }
        for (i = 0; i < 10000; ++i) {
            exp_sign = "";
            Exp = "" + (int)(rd.nextDouble() * 369.0);
            if (!rd.nextBoolean() && !Exp.equals("0")) {
                exp_sign = "-";
            }
            number = "" + rd.nextInt() + "E" + exp_sign + Exp;
            System.out.println("Input = " + number);
            DecFloat.fromString(DecFloatType.DECFLOAT16_LE, number, DecFloat16, 0, 8);
            result = DecFloat.toString(DecFloatType.DECFLOAT16_LE, DecFloat16, 0, 8);
            this.verifyStrings(result, number, "DFP16_LE random roundtrip " + i);
        }
        for (i = 0; i < 10000; ++i) {
            exp_sign = "";
            Exp = "" + (int)(rd.nextDouble() * 369.0);
            if (!rd.nextBoolean() && !Exp.equals("0")) {
                exp_sign = "-";
            }
            number = "" + rd.nextInt() + "E" + exp_sign + Exp;
            System.out.println("Input = " + number);
            DecFloat.fromString(DecFloatType.DECFLOAT16_BE, number, DecFloat16, 0, 8);
            result = DecFloat.toString(DecFloatType.DECFLOAT16_BE, DecFloat16, 0, 8);
            this.verifyStrings(result, number, "DFP16_BE random roundtrip " + i);
        }
    }

    void testRoundTrip() {
        byte[] DecFloat34 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "-29681467516828951121648748633E-5225", DecFloat34, 0, 16);
        String result = DecFloat.toString(DecFloatType.DECFLOAT34_LE, DecFloat34, 0, 16);
        this.verifyStrings(result, "-29681467516828951121648748633E-5225", "DFP34 roundtrip 1");
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "-89903706800806416962131435322E1680", DecFloat34, 0, 16);
        result = DecFloat.toString(DecFloatType.DECFLOAT34_LE, DecFloat34, 0, 16);
        this.verifyStrings(result, "-89903706800806416962131435322E1680", "DFP34 roundtrip 2");
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "-822413757737897101460506203E-3819", DecFloat34, 0, 16);
        result = DecFloat.toString(DecFloatType.DECFLOAT34_LE, DecFloat34, 0, 16);
        this.verifyStrings(result, "-822413757737897101460506203E-3819", "DFP34 roundtrip 3");
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "-751929289039203262918972942E-1275", DecFloat34, 0, 16);
        result = DecFloat.toString(DecFloatType.DECFLOAT34_LE, DecFloat34, 0, 16);
        this.verifyStrings(result, "-751929289039203262918972942E-1275", "DFP34 roundtrip 4");
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "2926782600322616412314840802000000E6083", DecFloat34, 0, 16);
        result = DecFloat.toString(DecFloatType.DECFLOAT34_LE, DecFloat34, 0, 16);
        this.verifyStrings(result, "2926782600322616412314840802000000E6083", "DFP34 roundtrip 5");
        DecFloat.fromString(DecFloatType.DECFLOAT34_LE, "2926782600322616412314840802E6083", DecFloat34, 0, 16);
        result = DecFloat.toString(DecFloatType.DECFLOAT34_LE, DecFloat34, 0, 16);
        this.verifyStrings(result, "2926782600322616412314840802E6083", "DFP34 roundtrip 6");
    }
}

