/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.MSGCollection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class StreamLog
extends Log {
    private static String subLoc = "Log";
    private OutputStream stream;
    private OutputStreamWriter out;
    private String enc;

    protected StreamLog() {
        this((String)null, (Formatter)new ListFormatter());
    }

    protected StreamLog(Formatter formatter) {
        this((String)null, formatter);
    }

    protected StreamLog(String enc, Formatter formatter) {
        super(formatter);
        if (enc == null) {
            enc = "UTF8";
        }
        this.enc = enc;
        this.stream = null;
        this.out = null;
    }

    public StreamLog(OutputStream stream) {
        this(stream, (Formatter)new ListFormatter());
    }

    public StreamLog(OutputStream stream, Formatter formatter) {
        super(formatter);
        this.stream = stream;
        this.enc = null;
        this.openInt();
    }

    public StreamLog(OutputStream stream, String enc) throws UnsupportedEncodingException {
        this(stream, enc, new ListFormatter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamLog(OutputStream stream, String enc, Formatter formatter) throws UnsupportedEncodingException {
        super(formatter);
        this.stream = stream;
        this.enc = enc;
        try {
            this.openInt();
        }
        finally {
            if (this.out == null && enc == null) {
                throw new UnsupportedEncodingException();
            }
        }
    }

    public synchronized String getEncoding() {
        return this.enc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoding(String enc) {
        String oldValue = "";
        String newValue = "";
        try {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                oldValue = this.getEncoding();
                this.enc = enc;
                this.closeInt();
                newValue = this.getEncoding();
            }
            APILogger.instrumentIntByAPI(subLoc + "[setEncoding(String enc)]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"encoding", "Log", this.getName(), oldValue, newValue});
        }
        catch (IOException ex) {
            APILogger.logIntByAPI(500, subLoc + "[setEncoding(...)]", "ASJ.log_api.000036", "Exception when trying to close this log({0})!", new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected synchronized OutputStream getOutputStream() {
        return this.stream;
    }

    protected synchronized void writeInt(String s) throws IOException {
        if (this.out != null) {
            this.out.write(s);
        }
    }

    protected synchronized void flushInt() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected synchronized void openInt() {
        if (this.stream != null) {
            if (this.enc != null) {
                try {
                    this.out = new OutputStreamWriter(this.stream, this.enc);
                }
                catch (UnsupportedEncodingException ex) {
                    APILogger.logIntByAPI(400, subLoc + "openInt()]", "ASJ.log_api.000040", "Unsupported encoding ''{0}''", new String[]{this.enc});
                    this.handleException(ex, 5);
                    this.out = new OutputStreamWriter(this.stream);
                    this.enc = this.out.getEncoding();
                }
            } else {
                this.out = new OutputStreamWriter(this.stream);
                this.enc = this.out.getEncoding();
            }
            this.setStatus(2);
        } else {
            this.out = null;
        }
    }

    protected synchronized void closeInt() throws IOException {
        this.flushInt();
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        this.setStatus(1);
    }

    synchronized void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }
}

