/*
 * Decompiled with CFR 0.152.
 */
package ynfp.open.sdk;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.binary.Base64;
import ynfp.open.sdk.ModuleHttp;
import ynfp.open.sdk.ModuleSign;
import ynfp.open.sdk.TokenModule;
import ynfp.open.sdk.YnfpException;

public class YnfpSdk {
    private static final YnfpSdk INSTANCE = new YnfpSdk();

    public static final YnfpSdk getIntance() {
        return INSTANCE;
    }

    private YnfpSdk() {
    }

    public String getMerchantToken(String appKey, String appSecret, String ... url) {
        this.verify(appKey, "AppKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "AppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        return TokenModule.getMerchantToken(appKey, appSecret, url);
    }

    public String getISVToken(String appKey, String appSecret, String code, String taxnum, String redirectUri, String ... url) {
        this.verify(code, "code\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(taxnum, "taxnum\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appKey, "AppKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "AppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(redirectUri, "redirectUri\u4e0d\u80fd\u4e3a\u7a7a");
        return TokenModule.getIsvToken(code, taxnum, appKey, appSecret, redirectUri, url);
    }

    public String refreshISVToken(String refreshToken, String userId, String appSecret, String ... url) {
        this.verify(userId, "userId\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(refreshToken, "refreshToken\u4e0d\u80fd\u4e3a\u7a7a");
        return TokenModule.refreshIsvToken(refreshToken, userId, appSecret, url);
    }

    public String sendPostSyncRequest(String url, String senid, String appKey, String appSecret, String token, String taxnum, String method, String content, int ... timeout) {
        this.verify(senid, "senid\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appKey, "appKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(method, "interfaceCode\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(url, "\u8bf7\u6c42\u5730\u5740URL\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(content, "content\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            long timestamp = System.currentTimeMillis() / 1000L;
            String nonce = String.valueOf(ThreadLocalRandom.current().nextInt(10000, 1000000000));
            StringBuffer sb = new StringBuffer(url);
            sb.append("?senid=").append(senid).append("&nonce=").append(nonce).append("&timestamp=").append(timestamp).append("&appkey=").append(appKey);
            Map<String, String> header = this.buildHeader(url, senid, appKey, appSecret, token, taxnum, method, content, nonce, String.valueOf(timestamp), null);
            return ModuleHttp.sendSyncHttp(sb.toString(), header, Base64.encodeBase64String((byte[])content.getBytes("UTF-8")), timeout);
        }
        catch (IOException var15) {
            throw new YnfpException("\u53d1\u9001HTTP\u8bf7\u6c42\u5f02\u5e38", var15);
        }
    }

    public String sendPostSyncRequest(String url, String senid, String appKey, String appSecret, String token, String taxnum, String method, String content, Map<String, String> header, int ... timeout) {
        this.verify(senid, "senid\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appKey, "appKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(method, "interfaceCode\u80fd\u4e3a\u7a7a");
        this.verify(url, "\u8bf7\u6c42\u5730\u5740URL\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(content, "content\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(appSecret, "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            long timestamp = System.currentTimeMillis() / 1000L;
            String nonce = String.valueOf(ThreadLocalRandom.current().nextInt(10000, 1000000000));
            StringBuffer sb = new StringBuffer(url);
            sb.append("?senid=").append(senid).append("&nonce=").append(nonce).append("&timestamp=").append(timestamp).append("&appkey=").append(appKey);
            header = this.buildHeader(url, senid, appKey, appSecret, token, taxnum, method, content, nonce, String.valueOf(timestamp), header);
            return ModuleHttp.sendSyncHttp(sb.toString(), header, content, timeout);
        }
        catch (IOException var15) {
            throw new YnfpException("\u53d1\u9001HTTP\u8bf7\u6c42\u5f02\u5e38", var15);
        }
    }

    public String convertToUtf8(String gbk) {
        try {
            byte[] gbkArr = gbk.getBytes("gbk");
            byte[] utf8Arr = new String(gbkArr, "gbk").getBytes("utf-8");
            return new String(utf8Arr, "utf-8");
        }
        catch (Exception var4) {
            throw new YnfpException("\u5b57\u7b26\u7f16\u7801\u8f6c\u6362\u5f02\u5e38", var4);
        }
    }

    private void verify(String v, String msg) {
        if (v == null || v.trim().length() == 0 || v.toLowerCase().trim().equals("null")) {
            throw new YnfpException(msg);
        }
    }

    private Map<String, String> buildHeader(String url, String senid, String appKey, String appSecret, String token, String taxnum, String interfaceCode, String content, String nonce, String timestamp, Map<String, String> header) throws MalformedURLException {
        URL httpUrl = new URL(url);
        String path = httpUrl.getPath();
        if (header == null || header.isEmpty()) {
            header = new HashMap<String, String>();
        }
        header.put("Content-Type", "application/json");
        header.put("X-Ynfp-Sign", ModuleSign.getSign(path, appSecret, appKey, senid, nonce, content, timestamp));
        header.put("accessToken", token);
        header.put("taxNum", taxnum);
        header.put("interfaceCode", interfaceCode);
        header.put("sdkVer", "1.0.5");
        return header;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String appKey = "19669989";
        appKey = "365";
        String appSecret = "o2sownbc-abdc-4f97-ba16-91c64e6544c0";
        YnfpSdk sdk = YnfpSdk.getIntance();
        System.out.println("\n\n\n\u3010\u5546\u6237\u83b7\u53d6Token\u3011");
        String senid = UUID.randomUUID().toString().replace("-", "");
        String req = "{\n    \"billNumber\":\"gmzjktest2021092909\",\n    \"billDate\":\"2021-09-26 12:25:11\",\n    \"expirationDate\":\"2\",\n    \"invoiceLine\":\"51\",\n    \"specialInvoiceFlag\":\"0\",\n    \"notes\":\"\u63a5\u53e3\",\n    \"callbackUrl\":\"http://www.baidu.com\",\n    \"invoiceDetail\":[\n        {\n            \"goodsName\":\"\u5c0f\u9ea6\",\n            \"goodsTaxNum\":\"101010101\",\n            \"goodsModel\":\"5\",\n            \"goodsUnit\":\"\u5343\u514b\",\n            \"taxFlag\":\"1\",\n            \"quantity\":\"1\",\n            \"price\":\"25\",\n            \"rate\":\"0.03\",\n            \"amount\":\"25\",\n            \"discountFlag\":\"0\",\n            \"discountType\":\"\",\n            \"zeroTax\":\"\",\n            \"invoiceProperties\":\"0\",\n            \"tax\":\"0.73\"\n        }\n    ]\n}";
        String sb = sdk.sendPostSyncRequest("http://192.168.21.82:9208/api/v1/eiInterface", senid, appKey, appSecret, "e8e9b5d5-6227-42d2-95f4-029378a541e3", "130100999999088", "ynfp.bill.scan.save", req, new int[0]);
        System.out.println(sb);
    }
}

