/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.controller;

import com.bizunited.empower.business.allowable.entity.CustomerBuyable;
import com.bizunited.empower.business.allowable.service.CustomerBuyableService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53ef\u8d2d\u6e05\u5355\u63a7\u5236\u5668"})
@RequestMapping(value={"/v1/customerBuyable"})
public class CustomerBuyableController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerBuyableController.class);
    @Autowired
    private CustomerBuyableService customerBuyableService;

    @PostMapping(value={""})
    @ApiOperation(value="\u4fdd\u5b58\u53ef\u8d2d\u6e05\u5355", notes="\u6839\u636e\u63d0\u4ea4\u7684\u6570\u636e\u8fdb\u884c\u53ef\u8d2d\u6e05\u5355\u7684\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseModel save(@RequestBody CustomerBuyable buyable) {
        try {
            CustomerBuyable result = this.customerBuyableService.save(buyable);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            CustomerBuyable current = this.customerBuyableService.findById(id);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @DeleteMapping(value={"/{id}"})
    public ResponseModel deleteById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            this.customerBuyableService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167CustomerBuyable\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            CustomerBuyable result = this.customerBuyableService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, new String[]{"products"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCode"})
    @ApiOperation(value="\u6839\u636e\u8d2d\u4e70\u8005\u7f16\u7801\u67e5\u8be2\u53ef\u8d2d\u6e05\u5355")
    public ResponseModel findDetailsByCode(@RequestParam @ApiParam(value="\u8d2d\u4e70\u8005\u7f16\u7801\uff0c\u5ba2\u6237\u7f16\u7801\u6216\u5ba2\u6237\u7ea7\u522b\u7f16\u7801") String code) {
        try {
            List<CustomerBuyable> buyables = this.customerBuyableService.findDetailsByCode(code);
            return this.buildHttpResultW(buyables, new String[]{"products"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCodeAndType"})
    @ApiOperation(value="\u6839\u636e\u8d2d\u4e70\u8005\u7f16\u7801\u3001\u8d2d\u4e70\u8005\u7c7b\u578b\u67e5\u8be2\u53ef\u8d2d\u6e05\u5355")
    public ResponseModel findDetailsByCodeAndType(@RequestParam @ApiParam(value="\u8d2d\u4e70\u8005\u7f16\u7801\uff0c\u5ba2\u6237\u7f16\u7801\u6216\u5ba2\u6237\u7ea7\u522b\u7f16\u7801") String code, @RequestParam @ApiParam(value="\u8d2d\u4e70\u8005\u7c7b\u578b") Integer type) {
        try {
            CustomerBuyable buyables = this.customerBuyableService.findDetailsByCodeAndType(code, type);
            return this.buildHttpResultW((Object)buyables, new String[]{"products"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

