/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.controller;

import com.bizunited.empower.business.allowable.entity.CustomerBuyableProduct;
import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53ef\u8d2d\u6e05\u5355\u5546\u54c1\u6e05\u5355\u63a7\u5236\u5668"})
@RequestMapping(value={"/v1/customerBuyableProduct"})
public class CustomerBuyableProductController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerBuyableProductController.class);
    @Autowired
    private CustomerBuyableProductService customerBuyableProductService;

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            CustomerBuyableProduct current = this.customerBuyableProductService.findById(id);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @DeleteMapping(value={"/{id}"})
    public ResponseModel deleteById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            this.customerBuyableProductService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167CustomerBuyableProduct\u5b9e\u4f53\u4e2d\u7684\uff08customerBuyable\uff09\u5173\u8054\u7684 \u5ba2\u6237\u53ef\u8d2d\u6e05\u5355\u4e3b\u6a21\u578b\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByCustomerBuyable"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCustomerBuyable(@RequestParam(value="customerBuyable") @ApiParam(value="\u5173\u8054\u7684 \u5ba2\u6237\u53ef\u8d2d\u6e05\u5355\u4e3b\u6a21\u578b") String customerBuyable) {
        try {
            Set<CustomerBuyableProduct> result = this.customerBuyableProductService.findDetailsByCustomerBuyable(customerBuyable);
            return this.buildHttpResultW(result, new String[]{"customerBuyable"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167CustomerBuyableProduct\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            CustomerBuyableProduct result = this.customerBuyableProductService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, new String[]{"customerBuyable"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCode"})
    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u7f16\u7801\u67e5\u8be2\u53ef\u8d2d\u8be6\u60c5")
    public ResponseModel findDetailsByCode(@RequestParam @ApiParam(value="\u5546\u54c1\u6216\u5546\u54c1\u5206\u7c7b\u6216\u5546\u54c1\u54c1\u724c\u7f16\u7801") String code) {
        try {
            List<CustomerBuyableProduct> products = this.customerBuyableProductService.findDetailsByCode(code);
            return this.buildHttpResultW(products, new String[]{"customerBuyable"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findSpecificationsByCustomerCode"})
    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u53ef\u8d2d\u4e70\u7684\u5546\u54c1\u89c4\u683c\u7f16\u7801")
    public ResponseModel findSpecificationsByCustomerCode(@RequestParam @ApiParam(value="\u5ba2\u6237\u7f16\u7801") String customerCode) {
        try {
            Set<String> products = this.customerBuyableProductService.findSpecificationsByCustomerCode(customerCode);
            return this.buildHttpResultW(products, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"validProducts"})
    @ApiOperation(value="\u9a8c\u8bc1\u5546\u54c1\u7f16\u7801\u96c6\u5408\u662f\u5426\u5728\u53ef\u8d2d\u6e05\u5355\u5185")
    public ResponseModel validProducts(@RequestParam @ApiParam(value="\u5ba2\u6237\u7f16\u7801") String customerCode, @RequestParam @ApiParam(value="\u5546\u54c1\u7f16\u7801\u96c6\u5408") List<String> productCodes) {
        try {
            boolean result = this.customerBuyableProductService.validProducts(customerCode, productCodes);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

