/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.controller;

import com.bizunited.empower.business.allowable.service.ProductVoService;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.script.context.InvokeParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1VO\u63a7\u5236\u5668"})
@RequestMapping(value={"/v1/productVo"})
@RestController(value="allowable_ProductVoController")
public class ProductVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductVoController.class);
    @Autowired
    private ProductVoService productVoService;

    @GetMapping(value={"findByCustomerCodeAndConditions"})
    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u548c\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u53c2\u6570\u4e3apage\u548csize\uff0cpage\u4ece0\u5f00\u59cb\uff0csize\u9ed8\u8ba450;\u53ef\u4f20\u7684\u53c2\u6570\uff1ashelfStatus\uff1a1 \u4e0a\u67b6 2 \u4e0b\u67b6\uff0cproductCode\uff1a\u5546\u54c1\u7f16\u7801/\u5546\u54c1\u540d\u79f0\uff08\u6a21\u7cca\uff09\uff0cbrandCode\uff1a\u54c1\u724c\u7f16\u7801\uff08\u7cbe\u51c6\uff09\uff0ccategoryCode\uff1a\u5206\u7c7b\u7f16\u7801\uff08\u7cbe\u51c6\uff09\uff0csellingPriceLeft/sellingPriceRight\uff1a\u9500\u552e\u4ef7\u683c\uff08\u8303\u56f4\uff09\uff0ctagCode\uff1a\u6807\u7b7e\u7f16\u7801\uff08\u7cbe\u51c6\uff09\uff0ccategoryFlatCode\uff1a\u5206\u7c7b\u5feb\u901f\u7f16\u53f7\uff08\u5b83\u548c\u5b83\u7684\u5b50\u96c6\uff09\uff0cbrandFlatCode\uff1a\u54c1\u724c\u5feb\u901f\u7f16\u53f7\uff08\u5b83\u548c\u5b83\u7684\u5b50\u96c6\uff09productCodeList\uff1a\u5546\u54c1\u7f16\u7801\u4ee5\u9017\u53f7\u95f4\u9694\u7684\u62fc\u63a5\u4e32")
    public ResponseModel findByCustomerCodeAndConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u5ba2\u6237\u7f16\u7801") String customerCode, HttpServletRequest request) {
        try {
            InvokeParams conditions = this.getInvokeParams(request);
            Page<ProductVo> page = this.productVoService.findByCustomerCodeAndConditions(pageable, customerCode, conditions);
            return this.buildHttpResult(page);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private InvokeParams getInvokeParams(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        InvokeParams conditions = new InvokeParams();
        conditions.putInvokeParams(params);
        return conditions;
    }
}

