/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.handle;

import com.bizunited.empower.business.allowable.entity.CustomerBuyableProduct;
import com.bizunited.empower.business.allowable.handle.ProductHandle;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerProductHandle {
    @Autowired
    private List<ProductHandle> productHandles;
    private Map<Integer, ProductHandle> productHandleMap = new HashMap<Integer, ProductHandle>();

    @PostConstruct
    public void init() {
        for (ProductHandle productHandle : this.productHandles) {
            this.productHandleMap.put(productHandle.getType(), productHandle);
        }
    }

    public Set<String> handle(CustomerBuyableProduct product) {
        ProductHandle productHandle = this.productHandleMap.get(product.getType());
        if (productHandle == null) {
            return Sets.newHashSet();
        }
        return productHandle.handle(product);
    }
}

