/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.service.event;

import com.bizunited.empower.business.allowable.common.enums.BuyerType;
import com.bizunited.empower.business.allowable.entity.CustomerBuyable;
import com.bizunited.empower.business.allowable.service.CustomerBuyableService;
import com.bizunited.empower.business.customer.service.notifier.CustomerEventListener;
import com.bizunited.empower.business.customer.vo.CustomerCategoryVo;
import com.bizunited.empower.business.customer.vo.CustomerLevelVo;
import com.bizunited.empower.business.customer.vo.CustomerVo;
import com.bizunited.empower.business.customer.vo.SalesAreaVo;
import com.bizunited.platform.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CustomerBuyableEventListenerImpl")
public class CustomerBuyableEventListenerImpl
implements CustomerEventListener {
    @Autowired
    private CustomerBuyableService customerBuyableService;

    public void onCreated(CustomerVo customer) {
        if (customer.getCustomerBuyable() == null) {
            return;
        }
        CustomerBuyable customerBuyable = (CustomerBuyable)((Object)JsonUtils.convert((Object)customer.getCustomerBuyable(), CustomerBuyable.class));
        customerBuyable.setCode(customer.getCustomerCode());
        customerBuyable.setType(BuyerType.CUSTOMER.getType());
        this.customerBuyableService.save(customerBuyable);
    }

    public void onUpdated(CustomerVo customer) {
        if (customer.getCustomerBuyable() == null) {
            return;
        }
        CustomerBuyable customerBuyable = (CustomerBuyable)((Object)JsonUtils.convert((Object)customer.getCustomerBuyable(), CustomerBuyable.class));
        customerBuyable.setCode(customer.getCustomerCode());
        customerBuyable.setType(BuyerType.CUSTOMER.getType());
        this.customerBuyableService.save(customerBuyable);
    }

    public void onEnabled(CustomerVo customer) {
    }

    public void onDisabled(CustomerVo customer) {
    }

    public void onLevelChanged(CustomerVo customer, CustomerLevelVo before, CustomerLevelVo after) {
    }

    public void onCategoryChanged(CustomerVo customer, CustomerCategoryVo before, CustomerCategoryVo after) {
    }

    public void onSalesAreaChanged(CustomerVo customer, SalesAreaVo before, SalesAreaVo after) {
    }
}

