/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.service.event;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.entity.CustomerCategory;
import com.bizunited.empower.business.customer.entity.SalesArea;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.customer.vo.CustomerCategoryVo;
import com.bizunited.empower.business.customer.vo.SalesAreaVo;
import com.bizunited.empower.business.product.service.notifier.ProductCustomerEventListener;
import com.bizunited.empower.business.product.vo.ProductPricingVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductCustomerEventListenerImpl
implements ProductCustomerEventListener {
    @Autowired
    private CustomerService customerService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public void setCustomerCategoryAndSalesArea(ProductVo productVo) {
        Validate.notNull((Object)productVo, (String)"\u5546\u54c1Vo\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set productPricings = productVo.getProductPricings();
        if (CollectionUtils.isEmpty((Collection)productPricings)) {
            return;
        }
        for (ProductPricingVo productPricing : productPricings) {
            CustomerCategory customerCategory;
            Customer customer;
            String customerCode = productPricing.getCustomerCode();
            if (StringUtils.isBlank((CharSequence)customerCode) || (customer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), customerCode)) == null) continue;
            SalesArea salesArea = customer.getSalesArea();
            if (salesArea != null) {
                SalesAreaVo salesAreaVo = (SalesAreaVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)salesArea, SalesAreaVo.class, HashSet.class, ArrayList.class, new String[0]);
                productPricing.setSalesArea(salesAreaVo);
            }
            if ((customerCategory = customer.getCustomerCategory()) == null) continue;
            CustomerCategoryVo customerCategoryVo = (CustomerCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerCategory, CustomerCategoryVo.class, HashSet.class, ArrayList.class, new String[0]);
            productPricing.setCustomerCategory(customerCategoryVo);
        }
    }
}

