/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.service.internal;

import com.bizunited.empower.business.allowable.entity.CustomerBuyable;
import com.bizunited.empower.business.allowable.entity.CustomerBuyableProduct;
import com.bizunited.empower.business.allowable.handle.BuyerTypeHandle;
import com.bizunited.empower.business.allowable.handle.CustomerProductHandle;
import com.bizunited.empower.business.allowable.model.BuyerModel;
import com.bizunited.empower.business.allowable.repository.CustomerBuyableProductRepository;
import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.empower.business.allowable.service.CustomerBuyableService;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="CustomerBuyableProductServiceImpl")
public class CustomerBuyableProductServiceImpl
implements CustomerBuyableProductService {
    @Autowired
    private CustomerBuyableProductRepository customerBuyableProductRepository;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private CustomerProductHandle customerProductHandle;
    @Autowired
    private CustomerBuyableService customerBuyableService;
    @Autowired
    private ProductSpecificationVoService productSpecificationService;
    @Autowired
    private List<BuyerTypeHandle> buyableProductHandles;

    @Override
    @Transactional
    public Set<CustomerBuyableProduct> save(CustomerBuyable buyable, Set<CustomerBuyableProduct> products) {
        this.saveValidation(buyable, products);
        this.customerBuyableProductRepository.deleteByCustomerBuyableId(buyable.getId());
        this.customerBuyableProductRepository.flush();
        Date now = new Date();
        String userAccount = SecurityUtils.getUserAccount();
        for (CustomerBuyableProduct product : products) {
            product.setCustomerBuyable(buyable);
            product.setCreateTime(now);
            product.setCreateAccount(userAccount);
            product.setModifyTime(now);
            product.setModifyAccount(userAccount);
            product.setId(null);
        }
        this.customerBuyableProductRepository.saveAll(products);
        return products;
    }

    private void saveValidation(CustomerBuyable buyable, Set<CustomerBuyableProduct> products) {
        Validate.notNull((Object)((Object)buyable), (String)"\u53ef\u8d2d\u6e05\u5355\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)buyable.getId(), (String)"\u53ef\u8d2d\u6e05\u5355\u5bf9\u8c61\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(products)) {
            return;
        }
        for (CustomerBuyableProduct product : products) {
            Validate.notNull((Object)product.getType(), (String)"\u53ef\u8d2d\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)product.getCode(), (String)"\u53ef\u8d2d\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((product.getCode().length() <= 64 ? 1 : 0) != 0, (String)"\u53ef\u8d2d\u5546\u54c1\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u957f\u4e8e64", (Object[])new Object[0]);
            Validate.isTrue((product.getName().length() <= 255 ? 1 : 0) != 0, (String)"\u53ef\u8d2d\u5546\u54c1\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u957f\u4e8e255", (Object[])new Object[0]);
        }
    }

    @Override
    public Set<CustomerBuyableProduct> findDetailsByCustomerBuyable(String customerBuyable) {
        if (StringUtils.isBlank((CharSequence)customerBuyable)) {
            return Sets.newHashSet();
        }
        return this.customerBuyableProductRepository.findDetailsByCustomerBuyable(customerBuyable);
    }

    @Override
    public CustomerBuyableProduct findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerBuyableProductRepository.findDetailsById(id);
    }

    @Override
    public CustomerBuyableProduct findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.customerBuyableProductRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        CustomerBuyableProduct current = this.findById(id);
        if (current != null) {
            this.customerBuyableProductRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void deleteByCustomerBuyableId(String customerBuyableId) {
        Validate.notBlank((CharSequence)customerBuyableId, (String)"\u5ba2\u6237\u53ef\u8d2d\u6e05\u5355\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerBuyableProductRepository.deleteByCustomerBuyableId(customerBuyableId);
        this.customerBuyableProductRepository.flush();
    }

    @Override
    public List<CustomerBuyableProduct> findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.customerBuyableProductRepository.findDetailsByTenantCodeAndCode(tenantCode, code);
    }

    @Override
    public Set<String> findSpecificationsByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return Sets.newHashSet();
        }
        String tenantCode = TenantUtils.getTenantCode();
        Customer customer = this.customerService.findDetailsByTenantCodeAndCustomerCode(tenantCode, customerCode);
        if (customer == null) {
            return Sets.newHashSet();
        }
        List<Object> buyerModels = Lists.newArrayList();
        for (BuyerTypeHandle buyableProductHandle : this.buyableProductHandles) {
            buyerModels.add(buyableProductHandle.handle(customer));
        }
        buyerModels = buyerModels.stream().sorted(Comparator.comparing(BuyerModel::getOrder)).collect(Collectors.toList());
        HashSet whiteCodes = Sets.newHashSet();
        HashSet blackCodes = Sets.newHashSet();
        HashSet allCodes = Sets.newHashSet((Iterable)this.productSpecificationService.findAllSpecificationCode());
        for (BuyerModel buyerModel : buyerModels) {
            Sets.SetView difference;
            CustomerBuyable customerBuyable = this.customerBuyableService.findDetailsByCodeAndType(buyerModel.getCode(), buyerModel.getType());
            if (customerBuyable == null) continue;
            Set<CustomerBuyableProduct> products = customerBuyable.getProducts();
            HashSet codes = Sets.newHashSet();
            if (!CollectionUtils.isEmpty(products)) {
                for (CustomerBuyableProduct product : products) {
                    codes.addAll(this.customerProductHandle.handle(product));
                }
            }
            if (customerBuyable.getBuyable().booleanValue()) {
                difference = Sets.difference((Set)codes, (Set)blackCodes);
                whiteCodes.addAll(difference);
                continue;
            }
            blackCodes.addAll(codes);
            difference = Sets.difference((Set)allCodes, (Set)codes);
            whiteCodes.addAll(difference);
        }
        return whiteCodes;
    }

    @Override
    public boolean validProducts(String customerCode, List<String> codes) {
        if (StringUtils.isBlank((CharSequence)customerCode) || CollectionUtils.isEmpty(codes)) {
            return false;
        }
        Set<String> buyableProductCodes = this.findSpecificationsByCustomerCode(customerCode);
        HashSet codeSet = Sets.newHashSet(codes);
        Sets.SetView intersection = Sets.intersection((Set)codeSet, buyableProductCodes);
        return codeSet.size() == intersection.size();
    }

    @Override
    public List<String> efficientProducts(String customerCode, List<String> codes) {
        if (StringUtils.isBlank((CharSequence)customerCode) || CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        Set<String> buyableProductCodes = this.findSpecificationsByCustomerCode(customerCode);
        HashSet codeSet = Sets.newHashSet(codes);
        Sets.SetView intersection = Sets.intersection((Set)codeSet, buyableProductCodes);
        return intersection.stream().collect(Collectors.toList());
    }
}

