/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.service.internal;

import com.bizunited.empower.business.allowable.entity.CustomerBuyable;
import com.bizunited.empower.business.allowable.repository.CustomerBuyableRepository;
import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.empower.business.allowable.service.CustomerBuyableService;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CustomerBuyableServiceImpl")
public class CustomerBuyableServiceImpl
implements CustomerBuyableService {
    @Autowired
    private CustomerBuyableRepository customerBuyableRepository;
    @Autowired
    private CustomerBuyableProductService customerBuyableProductService;

    @Override
    @Transactional
    public CustomerBuyable save(CustomerBuyable buyable) {
        this.saveValidation(buyable);
        String tenantCode = TenantUtils.getTenantCode();
        CustomerBuyable dbBuyable = this.customerBuyableRepository.findByTenantCodeAndCodeAndType(tenantCode, buyable.getCode(), buyable.getType());
        Date now = new Date();
        String userAccount = SecurityUtils.getUserAccount();
        if (dbBuyable == null) {
            dbBuyable = buyable;
            dbBuyable.setCreateTime(now);
            dbBuyable.setCreateAccount(userAccount);
            dbBuyable.setTenantCode(tenantCode);
            dbBuyable.setId(null);
        } else {
            dbBuyable.setBuyable(buyable.getBuyable());
        }
        dbBuyable.setModifyTime(now);
        dbBuyable.setModifyAccount(userAccount);
        this.customerBuyableRepository.save((Object)dbBuyable);
        this.customerBuyableProductService.save(dbBuyable, buyable.getProducts());
        return dbBuyable;
    }

    private void saveValidation(CustomerBuyable buyable) {
        Validate.notNull((Object)((Object)buyable), (String)"\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)buyable.getCode(), (String)"\u8d2d\u4e70\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((buyable.getCode().length() <= 64 ? 1 : 0) != 0, (String)"\u8d2d\u4e70\u8005\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u957f\u4e8e64", (Object[])new Object[0]);
        Validate.notNull((Object)buyable.getType(), (String)"\u8d2d\u4e70\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)buyable.getBuyable(), (String)"\u662f\u5426\u53ef\u8d2d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public CustomerBuyable findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerBuyableRepository.findDetailsById(id);
    }

    @Override
    public CustomerBuyable findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.customerBuyableRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        CustomerBuyable current = this.findById(id);
        if (current != null) {
            this.customerBuyableRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void deleteByCodeAndType(String code, Integer type) {
        Validate.notBlank((CharSequence)code, (String)"\u8d2d\u4e70\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)type, (String)"\u8d2d\u4e70\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        CustomerBuyable buyable = this.customerBuyableRepository.findByTenantCodeAndCodeAndType(tenantCode, code, type);
        if (buyable == null) {
            return;
        }
        this.customerBuyableProductService.deleteByCustomerBuyableId(buyable.getId());
        this.customerBuyableRepository.delete((Object)buyable);
    }

    @Override
    public List<CustomerBuyable> findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.customerBuyableRepository.findDetailsByTenantCodeAndCode(tenantCode, code);
    }

    @Override
    public CustomerBuyable findDetailsByCodeAndType(String code, Integer type) {
        if (StringUtils.isBlank((CharSequence)code) || type == null) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.customerBuyableRepository.findDetailsByTenantCodeAndCodeAndType(tenantCode, code, type);
    }
}

