/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.service.internal;

import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.empower.business.allowable.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.platform.common.constant.Constants;
import com.bizunited.platform.script.context.InvokeParams;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="allowable_ProductSpecificationVoServiceImpl")
public class ProductSpecificationVoServiceImpl
implements ProductSpecificationVoService {
    @Autowired
    private CustomerBuyableProductService customerBuyableProductService;
    @Autowired
    private com.bizunited.empower.business.product.service.ProductSpecificationVoService productSpecificationVoService;

    @Override
    public Page<ProductSpecificationVo> findByCustomerCodeAndConditions(Pageable pageable, String customerCode, InvokeParams conditions) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return Page.empty((Pageable)pageable);
        }
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)Constants.DEFAULT_PAGEABLE);
        conditions = (InvokeParams)ObjectUtils.defaultIfNull((Object)conditions, (Object)new InvokeParams());
        conditions.putInvokeParam("customerCode", (Object)customerCode);
        Set<String> productCodes = this.customerBuyableProductService.findSpecificationsByCustomerCode(customerCode);
        if (CollectionUtils.isEmpty(productCodes)) {
            return Page.empty((Pageable)pageable);
        }
        conditions.putInvokeParam("productCodeList", (Object)StringUtils.join(productCodes, (String)","));
        return this.productSpecificationVoService.findByConditions(pageable, conditions);
    }
}

