/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.service.internal;

import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.empower.business.allowable.service.ProductVoService;
import com.bizunited.empower.business.customer.service.CustomerRegisterService;
import com.bizunited.empower.business.product.service.notifier.ProductWarehouseEventListener;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.constant.Constants;
import com.bizunited.platform.script.context.InvokeParams;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="allowable_ProductVoServiceImpl")
public class ProductVoServiceImpl
implements ProductVoService {
    @Autowired
    private CustomerBuyableProductService customerBuyableProductService;
    @Autowired
    private CustomerRegisterService customerRegisterService;
    @Autowired
    private com.bizunited.empower.business.product.service.ProductVoService productVoService;
    @Autowired(required=false)
    private ProductWarehouseEventListener productWarehouseEventListener;

    @Override
    public Page<ProductVo> findByCustomerCodeAndConditions(Pageable pageable, String customerCode, InvokeParams conditions) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication == null) {
                return Page.empty((Pageable)pageable);
            }
            String account = authentication.getName();
            Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u767b\u5f55\u7528\u6237\uff01", (Object[])new Object[0]);
            if ("anonymousUser".equals(account)) {
                return this.productVoService.findByConditions(pageable, conditions);
            }
            List customerRegisters = this.customerRegisterService.findByPhone(account);
            if (CollectionUtils.isNotEmpty((Collection)customerRegisters)) {
                return this.productVoService.findByConditions(pageable, conditions);
            }
            return Page.empty((Pageable)pageable);
        }
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)Constants.DEFAULT_PAGEABLE);
        conditions = (InvokeParams)ObjectUtils.defaultIfNull((Object)conditions, (Object)new InvokeParams());
        conditions.putInvokeParam("customerCode", (Object)customerCode);
        Set<String> productCodes = this.customerBuyableProductService.findSpecificationsByCustomerCode(customerCode);
        if (org.springframework.util.CollectionUtils.isEmpty(productCodes)) {
            return Page.empty((Pageable)pageable);
        }
        List productSpecificationCodes = Lists.newArrayList();
        if (this.productWarehouseEventListener != null) {
            productSpecificationCodes = this.productWarehouseEventListener.findProductSpecificationCodesByCustomerCode(customerCode);
        }
        productCodes.retainAll(productSpecificationCodes);
        conditions.putInvokeParam("productCodeList", (Object)StringUtils.join(productCodes, (String)","));
        return this.productVoService.findByConditions(pageable, conditions);
    }
}

