/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.allowable.service.notifier;

import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.empower.business.product.entity.ProductSpecification;
import com.bizunited.empower.business.product.service.ProductSpecificationService;
import com.bizunited.empower.business.product.service.notifier.ProductCustomerBuyableEventListener;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductCustomerBuyableEventListenerImpl
implements ProductCustomerBuyableEventListener {
    @Autowired
    private CustomerBuyableProductService customerBuyableProductService;
    @Autowired
    private ProductSpecificationService productSpecificationService;

    public boolean isCustomerBuyable(String customerCode, String productSpecificationCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpecificationCode, (String)"\u5546\u54c1\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProductSpecification productSpecification = this.productSpecificationService.findByProductSpecificationCode(productSpecificationCode);
        Validate.notNull((Object)productSpecification, (String)"\u5546\u54c1\u89c4\u683c\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        return this.customerBuyableProductService.validProducts(customerCode, Lists.newArrayList((Object[])new String[]{productSpecificationCode}));
    }
}

