package com.bizunited.empower.business.common.config;

import com.bizunited.empower.business.common.service.notifier.HuaWeiFileEventListenerImpl;
import com.bizunited.platform.venus.sdk.event.VenusFileEventListener;
import com.obs.services.ObsClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * oss 对象存储配置
 *
 * @author Keller
 */
@Configuration
@ConditionalOnProperty(prefix = "venus.huawei", name = "enabled", havingValue = "true")
public class OSSConfiguration {
    /**
   * 华为授权 ak
   */
  @Value("${venus.huawei.access-key}")
  private String accessKey;
  /**
   * 华为授权 sk
   */
  @Value("${venus.huawei.secret-key}")
  private String secretKey;
  /**
   * 华为授权 endpoint
   */
  @Value("${venus.huawei.endpoint}")
  private String endpoint;
  /**
   * 华为授权 bucket
   */
  @Value("${venus.huawei.bucket}")
  private String bucket;

  /**
   * 华为obs文件服务实现
   *
   * @return
   */
  @Bean
  @Primary
  public VenusFileEventListener getHuaWeiFileService() {
    return new HuaWeiFileEventListenerImpl(accessKey, secretKey, endpoint, bucket);
  }
}
