package com.bizunited.empower.business.common.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.HashMap;
import java.util.Map;

/**
 * 签名app应用的配置信息
 * @Author: Paul Chan
 * @Date: 2020/8/3 11:17
 */
@ConfigurationProperties(prefix = "sign")
public class SignProperties {

  /**
   * app集合
   */
  private Map<String, AppInfo> apps = new HashMap<>();

  /**
   * 当前系统的appId标识
   */
  private String appId;

  /**
   * app信息
   */
  public static class AppInfo {
    /**
     * app的id标示，这个appID是唯一的
     */
    private String appId;
    /**
     * app的密钥，用于加密等
     */
    private String appKey;

    public String getAppId() {
      return appId;
    }

    public void setAppId(String appId) {
      this.appId = appId;
    }

    public String getAppKey() {
      return appKey;
    }

    public void setAppKey(String appKey) {
      this.appKey = appKey;
    }
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * 返回当前系统的appId
   * @return
   */
  public String getAppId() {
    return appId;
  }

  /**
   * 获取所有app信息
   * @return
   */
  public Map<String, AppInfo> getApps() {
    return apps;
  }

  /**
   * 根据appId获取app信息
   * @param appId
   * @return
   */
  public AppInfo getApp(String appId) {
    if(StringUtils.isBlank(appId)) {
      return null;
    }
    return apps.get(appId);
  }

}
