package com.bizunited.empower.business.common.config;


import com.bizunited.empower.business.common.service.internal.HuaWeiSmsServiceImpl;
import com.bizunited.platform.core.service.sms.SmsService;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * 短信发送配置
 *
 * @author Keller
 */
@Configuration
public class SimpleSmsConfiguration {

  /**
   * 初始化华为短信发送实现
   * TODO 有时间可以抽取成配置形式，通过配置形式支持多种渠道的短信发送
   */
  @Bean
  @Primary
  @ConditionalOnMissingBean(SmsService.class)
  @ConditionalOnClass(CloseableHttpClient.class)
  public SmsService getHuaWeiSmservice() {
    return new HuaWeiSmsServiceImpl();
  }

}
