package com.bizunited.empower.business.common.interceptor;

import com.bizunited.platform.core.interceptor.NebulaRequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 调用运营平台的拦截器处理,在请求saas平台时在header中添加referer
 * @Author: Paul Chan
 * @Date: 2021/5/17 下午4:44
 */
@Component
public class SaasRequestInterceptor implements NebulaRequestInterceptor {

  /**
   * Referer名称
   */
  private static final String REFERER_NAME = "Referer";

  /**
   * saas 调用地址
   */
  @Value("${saas.baseUrl:}")
  private String saasBaseUrl;


  @Override
  public void apply(RequestTemplate requestTemplate) {
    if(StringUtils.isBlank(saasBaseUrl)) {
      return;
    }
    requestTemplate.header(REFERER_NAME, saasBaseUrl);
  }


}
