package com.bizunited.empower.business.common.service.notifier;

import com.bizunited.platform.venus.sdk.event.VenusFileEventListener;
import com.obs.services.ObsClient;
import com.obs.services.model.ObsObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

/**
 * 华为 OBS 文件上传
 * @author Keller , yinwenjie
 */
public class HuaWeiFileEventListenerImpl implements VenusFileEventListener {
  /**
   * 日志
   */
  private final static Logger log = LoggerFactory.getLogger(HuaWeiFileEventListenerImpl.class);
  /**
   * 华为授权 ak
   */
  private String accessKey;
  /**
   * 华为授权 sk
   */
  private String secretKey;
  /**
   * 华为授权 endpoint
   */
  private String endpoint;
  /**
   * 华为授权 bucket
   */
  private String bucket;

  public HuaWeiFileEventListenerImpl(String accessKey, String secretKey, String endpoint, String bucket) {
    this.accessKey = accessKey;
    this.secretKey = secretKey;
    this.endpoint = endpoint;
    this.bucket = bucket;
  }

  @Override
  public void onSaveFile(String relativePath, String fileName, String fileRename, byte[] fileContext) {
    try (ObsClient obsClient = buildObsClient()) {
      obsClient.putObject(bucket, relativePath + File.separator + fileRename, new ByteArrayInputStream(fileContext));
    } catch (Exception e) {
      log.error(String.format("上传文件错误:%s", e.getMessage()), e);
    }
  }

  @Override
  public void onDeleteFile(String relativePath, String fileName, String fileRename) {
    try (ObsClient obsClient = buildObsClient()) {
      obsClient.deleteObject(bucket, relativePath + File.separator + fileRename);
    } catch (Exception e) {
      log.error(String.format("删除文件错误:%s", e.getMessage()), e);
    }
  }

  @Override
  public byte[] onReadFileContent(String relativePath, String fileRename) {
    byte[] fileContents = new byte[0];
    try (ObsClient obsClient = buildObsClient();
         ByteArrayOutputStream out = new ByteArrayOutputStream()) {
      ObsObject obsObject = obsClient.getObject(bucket, relativePath + File.separator + fileRename);
      int maxLen = 204800;
      byte[] readContext = new byte[maxLen];
      while (true) {
        int realen;
        if ((realen = obsObject.getObjectContent().read(readContext, 0, maxLen)) == -1) {
          fileContents = out.toByteArray();
          break;
        }
        out.write(readContext, 0, realen);
      }
    } catch (IOException e) {
      log.error(String.format("无法读取对象内容流:%s", e.getMessage()), e);
    }
    return fileContents;
  }

  /**
   * 创建华为obsClient
   *
   * @return
   */
  private ObsClient buildObsClient() {
    return new ObsClient(accessKey, secretKey, endpoint);
  }
}
