package com.bizunited.empower.business.common.util;

import org.apache.commons.lang3.Validate;

import java.util.Calendar;
import java.util.Date;

/**
 * 日期相关的工具，如获取指定日期的开始时间，结束时间等
 * @Author: Paul Chan
 * @Date: 2021/4/25 下午4:10
 */
public class DateUtils {

  private DateUtils() {
    throw new IllegalStateException("静态工具类不能实例化");
  }

  /**
   * 获取昨天日期的开始时间
   * @return
   */
  public static Date getYesterdayStartDate() {
    Calendar calendar = Calendar.getInstance();
    calendar.add(Calendar.DAY_OF_MONTH, -1);
    return getStartDate(calendar.getTime());
  }

  /**
   * 获取昨天日期的结束时间
   * @return
   */
  public static Date getYesterdayEndDate() {
    Calendar calendar = Calendar.getInstance();
    calendar.add(Calendar.DAY_OF_MONTH, -1);
    return getEndDate(calendar.getTime());
  }

  /**
   * 获取指定日期的开始时间，除了年月日，其他时间全部设置为0
   * @param date
   * @return
   */
  public static Date getStartDate(Date date) {
    Validate.notNull(date, "date not be null");
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(date);
    calendar.set(Calendar.HOUR_OF_DAY, 0);
    calendar.set(Calendar.MINUTE, 0);
    calendar.set(Calendar.SECOND, 0);
    calendar.set(Calendar.MILLISECOND, 0);
    return calendar.getTime();
  }

  /**
   * 获取指定日期的结束时间，指定日期的23时59分59秒0毫秒
   * @param date
   * @return
   */
  public static Date getEndDate(Date date) {
    Validate.notNull(date, "date not be null");
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(date);
    calendar.set(Calendar.HOUR_OF_DAY, 23);
    calendar.set(Calendar.MINUTE, 59);
    calendar.set(Calendar.SECOND, 59);
    calendar.set(Calendar.MILLISECOND, 0);
    return calendar.getTime();
  }

}
