package com.bizunited.empower.business.common.util;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * md5工具类
 * @Author: Paul Chan
 * @Date: 2020/8/3 14:33
 */
public class Md5Utils {
  private static final Logger LOGGER = LoggerFactory.getLogger(Md5Utils.class);

  private Md5Utils() {
    throw new IllegalStateException("静态类不能进行初始化");
  }

  /**
   * 将文本内容进行md5加密
   * @param content
   * @param encodeType
   * @return
   */
  public static String encode(String content, EncodeType encodeType){
    Validate.notNull(content, "加密文本不能为null");
    String resultString = null;
    encodeType = ObjectUtils.defaultIfNull(encodeType, EncodeType.HEX);
    try {
      MessageDigest md = MessageDigest.getInstance("MD5");
      byte[] bytes = md.digest(content.getBytes(StandardCharsets.UTF_8));
      switch (encodeType) {
        case HEX:
          resultString = Hex.encodeHexString(bytes);
          break;
        case BASE64:
          resultString = Base64Utils.encodeToString(bytes);
          break;
        default:
          break;
      }
    } catch (NoSuchAlgorithmException e) {
      // 不会触发这个异常，所以吃掉了
      LOGGER.warn(e.getMessage(), e);
    }
    return resultString;
  }

  /**
   * 编码方式
   */
  public static enum EncodeType {
    HEX, BASE64
  }

}
