package com.bizunited.empower.business.common.util;

import org.apache.commons.lang3.Validate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import java.security.Principal;

/**
 * 本地权限认证的相关工具，目前提供当前登录人信息的获取
 * @Author: Paul Chan，yinwenjie
 * @Date: 2020-04-17 14:13
 */
public final class SecurityUtils {
  /**
   * 匿名用户
   */
  public static final String ANONYMOUS_USER = "anonymousUser";
  
  /**
   * 不允许实例化工具类
   */
  private SecurityUtils() {
    throw new IllegalStateException("静态工具类不允许实例化");
  }

  /**
   * 获取当前系统登录人的代理对象
   * @return
   */
  public static Principal getPrincipal() {
    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
    Validate.notNull(authentication , "当前系统未登录用户！");
    return authentication;
  }
  
  /**
   * 获取当前系统的登录人账号，返回的是Principal的name属性
   * @return 
   */
  public static String getUserAccount() {
    Principal principal = getPrincipal();
    String account = principal.getName();
    Validate.notBlank(account , "当前系统未登录用户！");
    Validate.isTrue(!ANONYMOUS_USER.equals(account), "当前系统未登录用户！");
    return account;
  }
}